% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_http.R
\docType{class}
\name{zarr_httpstore}
\alias{zarr_httpstore}
\title{Zarr Store for HTTP access}
\description{
This class implements a Zarr HTTP store. With this class Zarr
stores on web servers can be read. For Zarr v.2 HTTP stores there exists a
standard for publishing arrays on the store, using consolidated metadata.
This class will look for such metadata in the root of the store. If no
consolidated metadata is found then a regular group or array is searched
for. Note that if a group is found that there is no standard process to
determine what arrays are available in the store and where they are located
relative to the root. Typically such information is found in the attributes
of the group and you are advised to inspect those attributes and refer to
the documentation of the store publisher.

This class performs no sanity checks on any of the arguments passed to the
methods, for performance reasons. Since this class should be accessed
through group and array objects, it is up to that code to ensure that
arguments are valid, in particular keys and prefixes.
}
\section{Super class}{
\code{\link[zarr:zarr_store]{zarr::zarr_store}} -> \code{zarr_httpstore}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) Name of the class for printing.}

\item{\code{root}}{(read-only) The root of the HTTP store, identical to its URL.}

\item{\code{uri}}{(read-only) The URI of the store location.}

\item{\code{separator}}{(read-only) The default chunk separator of the store,
usually a slash '/'.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_httpstore-new}{\code{zarr_httpstore$new()}}
\item \href{#method-zarr_httpstore-exists}{\code{zarr_httpstore$exists()}}
\item \href{#method-zarr_httpstore-clear}{\code{zarr_httpstore$clear()}}
\item \href{#method-zarr_httpstore-erase}{\code{zarr_httpstore$erase()}}
\item \href{#method-zarr_httpstore-erase_prefix}{\code{zarr_httpstore$erase_prefix()}}
\item \href{#method-zarr_httpstore-list_dir}{\code{zarr_httpstore$list_dir()}}
\item \href{#method-zarr_httpstore-list_prefix}{\code{zarr_httpstore$list_prefix()}}
\item \href{#method-zarr_httpstore-set}{\code{zarr_httpstore$set()}}
\item \href{#method-zarr_httpstore-set_if_not_exists}{\code{zarr_httpstore$set_if_not_exists()}}
\item \href{#method-zarr_httpstore-get}{\code{zarr_httpstore$get()}}
\item \href{#method-zarr_httpstore-get_metadata}{\code{zarr_httpstore$get_metadata()}}
\item \href{#method-zarr_httpstore-set_metadata}{\code{zarr_httpstore$set_metadata()}}
\item \href{#method-zarr_httpstore-is_group}{\code{zarr_httpstore$is_group()}}
\item \href{#method-zarr_httpstore-create_group}{\code{zarr_httpstore$create_group()}}
\item \href{#method-zarr_httpstore-create_array}{\code{zarr_httpstore$create_array()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="getsize"><a href='../../zarr/html/zarr_store.html#method-zarr_store-getsize'><code>zarr::zarr_store$getsize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="getsize_prefix"><a href='../../zarr/html/zarr_store.html#method-zarr_store-getsize_prefix'><code>zarr::zarr_store$getsize_prefix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="is_empty"><a href='../../zarr/html/zarr_store.html#method-zarr_store-is_empty'><code>zarr::zarr_store$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="list"><a href='../../zarr/html/zarr_store.html#method-zarr_store-list'><code>zarr::zarr_store$list()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.

HTTP stores are read-only. Currently two types of Zarr store can be
accessed. A Zarr v.2 consolidated metadata file at the root of the
store (immediately below the URL) can identify a hierarchy of groups
and arrays. Alternatively, a store with a group or a single array,
either v.2 or v.3.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$new(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The path to the HTTP store to be opened. The URL may use UTF-8
code points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-exists"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-exists}{}}}
\subsection{Method \code{exists()}}{
Check if a key exists in the store. The key can point to a
group, an array, or a metadata file. This check is only relevant for
HTTP stores with consolidated metadata. In other cases the single group
or array will be at the root.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Character string. The key that the store will be searched for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if argument \code{key} is found, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-clear"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-clear}{}}}
\subsection{Method \code{clear()}}{
Clearing the store is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-erase"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-erase}{}}}
\subsection{Method \code{erase()}}{
Removing a key from the store is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$erase(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-erase_prefix"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-erase_prefix}{}}}
\subsection{Method \code{erase_prefix()}}{
Removing keys from the store is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$erase_prefix(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-list_dir"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-list_dir}{}}}
\subsection{Method \code{list_dir()}}{
Retrieve all keys and prefixes with a given prefix and which
do not contain the character "/" after the given prefix. In other
words, this retrieves all the nodes in the store below the node
indicated by the prefix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$list_dir(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Character string. The prefix whose nodes to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character array with all keys found in the store immediately
below the \code{prefix}, both for groups and arrays.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-list_prefix"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-list_prefix}{}}}
\subsection{Method \code{list_prefix()}}{
Retrieve all keys and prefixes with a given prefix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$list_prefix(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Character string. The prefix whose nodes to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector with all paths found in the store below the
\code{prefix} location, both for groups and arrays.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-set"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-set}{}}}
\subsection{Method \code{set()}}{
Storing a \verb{(key, value)} pair is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Ignored.}

\item{\code{value}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-set_if_not_exists"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-set_if_not_exists}{}}}
\subsection{Method \code{set_if_not_exists()}}{
Storing a \verb{(key, value)} pair is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$set_if_not_exists(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Ignored.}

\item{\code{value}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-get"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-get}{}}}
\subsection{Method \code{get()}}{
Retrieve the value associated with a given key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$get(key, prototype = NULL, byte_range = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Character string. The key for which to get data.}

\item{\code{prototype}}{Ignored. The only buffer type that is supported maps
directly to an R raw vector.}

\item{\code{byte_range}}{Ignored. The full data value is always returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A raw vector with the data pointed at by the key.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Retrieve the metadata document of the node at the location
indicated by the \code{prefix} argument. The metadata will always be
presented to the caller in the Zarr v.3 format. Attributes, if present,
will be added.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$get_metadata(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{The prefix of the node whose metadata document to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the metadata, or \code{NULL} if the prefix is not pointing
to a Zarr group or array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-set_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-set_metadata}{}}}
\subsection{Method \code{set_metadata()}}{
Setting metadata is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$set_metadata(prefix, metadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Ignored.}

\item{\code{metadata}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-is_group"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-is_group}{}}}
\subsection{Method \code{is_group()}}{
Test if \code{path} is pointing to a Zarr group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$is_group(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the \code{path} points to a Zarr group, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-create_group"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-create_group}{}}}
\subsection{Method \code{create_group()}}{
Creating a new group in the store is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$create_group(path, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path, name}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An error indicating that the group could not be created.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_httpstore-create_array"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_httpstore-create_array}{}}}
\subsection{Method \code{create_array()}}{
Creating a new array in the store is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_httpstore$create_array(parent, name, metadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent, name, metadata}}{Ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An error indicating that the array could not be created.
}
}
}
