# Extracted from test-CFI.R:30

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("arf")
set.seed(123)
task = tgen("2dnormals")$generate(n = 100)
test_basic_workflow(
		CFI,
		task = task,
		learner = lrn("classif.ranger", num.trees = 50, predict_type = "prob"),
		measure = msr("classif.ce"),
		expected_classes = c("FeatureImportanceMethod", "PerturbationImportance", "CFI")
	)
