% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaEvalPopulation.R
\name{xegaEvalPopulation}
\alias{xegaEvalPopulation}
\title{Evaluates a population of genes in a problem environment}
\usage{
xegaEvalPopulation(pop, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{lF}{Local function configuration.}
}
\value{
List of
        \itemize{
        \item \code{$pop} gene vector,
        \item \code{$fit} fitness vector, 
        \item \code{$evalFail} number of failed evaluations.
        }
}
\description{
\code{xegaEvalPopulation()} evaluates a population
                 of genes in a problem environment.
}
\details{
Parallelization of the evaluation of fitness functions
         is possible by defining \code{lF$lapply}.
}
\examples{
pop5<-xegaInitPopulation(5, lFxegaGaGene)
lFxegaGaGene[["lapply"]]<-ApplyFactory(method="Sequential") 
result<-xegaEvalPopulation(pop5, lFxegaGaGene)
result
lFxegaGaGene$Pipeline<-function() {"PipeC"}
pop5c<-asPipeline(pop5, lFxegaGaGene)
pop5c
result<-xegaEvalPopulation(pop5c, lFxegaGaGene)
result
lFxegaGaGene$Pipeline<-function() {"PipeG"}
pop5c<-asPipelineG(pop5, lFxegaGaGene)
pop5c
result<-xegaEvalPopulation(pop5c, lFxegaGaGene)
result
}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaRepEvalPopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
