% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicate2Gene}
\alias{xegaGaReplicate2Gene}
\title{Replicates a gene with a crossover operator with 2 kids.}
\usage{
xegaGaReplicate2Gene(pop, fit, lF)
}
\arguments{
\item{pop}{A population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of either 1 or 2 binary genes.
}
\description{
\code{xegaGaReplicate2Gene()} replicates a gene
             by 2 random experiments which determine if a mutation 
             operator (boolean variable \code{mut})  and/or 
             a crossover operator (boolean variable \code{cross} 
             should be applied. For each of the 4 cases, the 
             appropriate code is executed and the genes are generated.
}
\details{
\code{xegaGaReplicate2Gene()} implements the control flow 
         by case distinction which  depends
         on the random choices for mutation and crossover:
\enumerate{
  \item A gene \code{g} is selected and the boolean variables \code{mut}
        and \code{cross} are set to \code{runif(1)<rate}. 
        \code{rate} is given by 
        \code{lF$MutationRate()} or \code{lF$CrossRate()}. 
  \item The truth values of \code{cross} and \code{mut} determine 
        the code that is executed:
  \enumerate{      
  \item \code{(cross==TRUE) & (mut==TRUE)}: 
          Mate selection,  crossover, mutation. 
  \item \code{(cross==TRUE) & (mut==FALSE)}: 
          Mate selection, crossover. 
  \item \code{(cross==FALSE) & (mut==TRUE)}: 
          Mutation. 
  \item \code{(cross==FALSE) & (mut==FALSE)} is implicit: 
         Returns a gene list. 
  }
  }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
names(lFxegaGaGene)
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicate2Gene(pop10, fit10, lFxegaGaGene)

}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicate2GenePipeline}()},
\code{\link{xegaGaReplicate2GenePipelineG}()},
\code{\link{xegaGaReplicateGene}()},
\code{\link{xegaGaReplicateGenePipeline}()},
\code{\link{xegaGaReplicateGenePipelineG}()}
}
\concept{Replication}
