% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfReplicate.R
\name{xegaDfReplicateGeneDEPipelineG}
\alias{xegaDfReplicateGeneDEPipelineG}
\title{Generates a gene with an embedded gene pipeline for differential evolution.}
\usage{
xegaDfReplicateGeneDEPipelineG(pop, fit, lF)
}
\arguments{
\item{pop}{Population of real-coded genes.}

\item{fit}{Fitness vector.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A gene with an embedded differential evolution pipeline.
}
\description{
\code{xegaDfReplicateGeneDEPipelineG()} embeds  
             a gene pipeline for differential evolution and the 
             genes necessary to evaluate it into a gene.
             Replication
             is the reproduction function which uses crossover and
             mutation. The control flow of differential evolution 
             is as follows:
             \itemize{
             \item A target gene is selected from the population.
             \item A mutant gene is generated by differential mutation.
             \item The gene and the mutant gene are crossed to get a 
                   new gene.
             \item The gene is accepted if it is at least as good 
                   as the target gene.
             }
             The execution is shifted to the evaluation phase.
}
\details{
For \code{selection="UniformP"},
         for \code{crossover="UPCrossGene"} and
         for \code{accept="Best"}
         this is 
         the algorithm of Price, Storn and Lampinen (2005), page 41.

         To concentrate sampling around the best gene for 
         faster convergence of global functions, configure
         \code{selection="TopK"} and around the best 3 genes,
         add \code{topK=3}.

         \code{xegaDfReplicateGeneDEPipelineG()} is a genetic operator
         constructor which generates a gene with an embedded differential
         evolution operator pipeline
         (differential mutation, crossover and the acceptance rule).
}
\examples{
pop10<-lapply(rep(0,10), function(x) xegaDfGene::xegaDfInitGene(lFxegaDfGene))
epop10<-lapply(pop10, lFxegaDfGene$EvalGene, lF=lFxegaDfGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
ng<-xegaDfReplicateGeneDEPipelineG(pop10, fit10, lFxegaDfGene)
g<-ng[[1]]$Pipeline(ng[[1]], lFxegaDfGene)
}
\references{
Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134.
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\seealso{
Other Replication: 
\code{\link{xegaDfReplicateGeneDE}()},
\code{\link{xegaDfReplicateGeneDEPipeline}()}
}
\concept{Replication}
