% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-compustat.R
\name{sic_2digit}
\alias{sic_2digit}
\title{Convert SIC codes to 2-digit industry codes}
\usage{
sic_2digit(sic)
}
\arguments{
\item{sic}{A numeric or character vector of SIC codes.}
}
\value{
A character vector of 2-digit SIC codes.
}
\description{
Extracts the first two characters from SIC codes to create broader
industry classifications.
}
\details{
SIC codes are hierarchical: the first two digits represent major industry
groups (e.g., "54" = Retail-Food Stores), while the full 4-digit code
provides more specific classifications (e.g., "5412" = Retail-Convenience Stores).
}
\examples{
# Convenience Stores (SIC 5412) -> Retail-Food Stores (54)
sic_2digit(5412)
# [1] "54"

sic_2digit(c(5412, 5400))
# [1] "54" "54"
}
