% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikipages.R
\name{wt_wiki_url_build}
\alias{wt_wiki_url_build}
\title{Build MediaWiki Page URL}
\usage{
wt_wiki_url_build(
  wiki,
  type = NULL,
  page = NULL,
  api = FALSE,
  action = "parse",
  redirects = TRUE,
  format = "json",
  utf8 = TRUE,
  prop = c("text", "langlinks", "categories", "links", "templates", "images",
    "externallinks", "sections", "revid", "displaytitle", "iwlinks", "properties")
)
}
\arguments{
\item{wiki}{(character | list) Either the wiki name or a list with
\verb{$wiki}, \verb{$type}, and \verb{$page} (the output of \code{\link[=wt_wiki_url_parse]{wt_wiki_url_parse()}}).}

\item{type}{(character) Wiki type.}

\item{page}{(character) Wiki page title.}

\item{api}{(boolean) Whether to return an API call or a static page url
(default). If \code{FALSE}, all following (API-only) arguments are ignored.}

\item{action}{(character) See \url{https://en.wikipedia.org/w/api.php}
for supported actions. This function currently only supports "parse".}

\item{redirects}{(boolean) If the requested page is set to a redirect,
resolve it.}

\item{format}{(character) See \url{https://en.wikipedia.org/w/api.php}
for supported output formats.}

\item{utf8}{(boolean) If \code{TRUE}, encodes most (but not all) non-ASCII
characters as UTF-8 instead of replacing them with hexadecimal escape
sequences.}

\item{prop}{(character) Properties to retrieve, either as a character vector
or pipe-delimited string. See
\url{https://en.wikipedia.org/w/api.php?action=help&modules=parse} for
supported properties.}
}
\value{
a URL (character)
}
\description{
Builds a MediaWiki page url from its component parts (wiki name, wiki type,
and page title). Supports both static page urls and their equivalent API
calls.
}
\examples{
wt_wiki_url_build(wiki = "en", type = "wikipedia", page = "Malus domestica")
wt_wiki_url_build(
  wt_wiki_url_parse("https://en.wikipedia.org/wiki/Malus_domestica"))
wt_wiki_url_build("en", "wikipedia", "Malus domestica", api = TRUE)
}
\seealso{
Other MediaWiki functions: 
\code{\link{wt_wiki_page}()},
\code{\link{wt_wiki_page_parse}()},
\code{\link{wt_wiki_url_parse}()}
}
\concept{MediaWiki functions}
