% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stray.R
\name{stray_scores}
\alias{stray_scores}
\title{Stray scores}
\usage{
stray_scores(y, ...)
}
\arguments{
\item{y}{A vector, matrix, or data frame consisting of numerical variables.}

\item{...}{Other arguments are passed to \code{\link[stray]{find_HDoutliers}}.}
}
\value{
Numerical vector containing stray scores.
}
\description{
Compute stray scores indicating how anomalous each observation is.
}
\examples{
# Univariate data
y <- c(6, rnorm(49))
scores <- stray_scores(y)
threshold <- stray::find_threshold(scores, alpha = 0.01, outtail = "max", p = 0.5, tn = 50)
which(scores > threshold)
}
\references{
P D Talagala, R J Hyndman and K Smith-Miles (2021) Anomaly detection
in high-dimensional data, \emph{Journal of Computational and Graphical Statistics}, \strong{30}(2), 360-374.
}
\author{
Rob J Hyndman
}
