% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_functions.R
\name{pk_iv_1cmt}
\alias{pk_iv_1cmt}
\title{Simulate PK data from a 1-compartment iv model}
\usage{
pk_iv_1cmt(
  t,
  t_inf = 1,
  tau = 24,
  dose = 120,
  CL = 0.345,
  Vc = 1.75,
  ruv = NULL
)
}
\arguments{
\item{t}{Time after dose}

\item{t_inf}{Infusion length}

\item{tau}{Dosing interval}

\item{dose}{Dose}

\item{CL}{Clearance}

\item{Vc}{Volume of distribution}

\item{ruv}{Residual variability}
}
\value{
A vector of predicted values, with or without added residual variability
}
\description{
Simulate PK data from a 1-compartment iv model
}
\examples{
dat1 <- vpc:::pk_iv_1cmt(t = c(0:72), tau = 24, dose = 120,
                   CL = 5, Vc = 50)
dat2 <- vpc:::pk_iv_1cmt(t = c(0:72), tau = 24, dose = 120,
                   CL = 5, Vc = 50,
                   ruv = list(proportional = 0.1, additive = 0.1))
}
