% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_bins.R
\name{define_bins}
\alias{define_bins}
\alias{define_bins_tte}
\title{Define bins for many types of data}
\usage{
define_bins(obs, sim, bins, n_bins, verbose = FALSE)

define_bins_tte(obs, sim, bins, n_bins, kmmc, verbose = FALSE)
}
\arguments{
\item{obs}{a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}}

\item{sim}{this is usually a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}.  However it can also be an object like a nlmixr or xpose object}

\item{bins}{either "density", "time", or "data", "none", or one of the
approaches available in classInterval() such as "jenks" (default) or
"pretty", or a numeric vector specifying the bin separators.}

\item{n_bins}{when using the "auto" binning method, what number of bins to
aim for}

\item{verbose}{show debugging information (TRUE or FALSE)}

\item{kmmc}{either NULL (for regular TTE vpc, default), or a variable name for a KMMC plot (e.g. "WT")}
}
\value{
A list with named elements: "bins", the bin separator values;
  "labeled", are the bins labeled?; "obs", binned observed data; "sim",
  binned simulated data.  Additionally, "tmp_bins" is added for tte data.
}
\description{
Define bins for many types of data
}
\section{Functions}{
\itemize{
\item \code{define_bins_tte()}: Define bins for time-to-event data

}}
