% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVI_update_function.R
\name{CVI_update_function}
\alias{CVI_update_function}
\title{Update of the variational parameters}
\usage{
CVI_update_function(
  fixed_variance = FALSE,
  covariance_type = "diagonal",
  cluster_specific_covariance = TRUE,
  variance_prior_type = c("IW", "decomposed", "sparse", "off-diagonal normal"),
  X,
  inverts,
  params
)
}
\arguments{
\item{fixed_variance}{whether the covariance is fixed or estimated.
Default is \code{FALSE} which means it is estimated.}

\item{covariance_type}{The assumed type of the covariance matrix.
Can be either \code{"diagonal"} if it is the identify multiplied by a scalar,
or \code{"full"} for a fully unspecified covariance matrix.}

\item{cluster_specific_covariance}{whether the the covariance is shared across
estimated clusters or is cluster specific. Default is \code{TRUE} which means it is cluster specific.}

\item{variance_prior_type}{character string specifying the type of prior distribution
for the covariance when cluster_specific_covariance is \code{TRUE}.
Can be either \code{"IW"} or \code{"decomposed"} if \code{cluster_specific_covariance} is \code{FALSE},
and can be either \code{"IW"}, \code{"sparse"} or \code{"off-diagonal normal"} otherwise.}

\item{X}{the data matrix}

\item{inverts}{a list of inverses}

\item{params}{a list of required arguments}
}
\value{
Updated parameters
}
\description{
Update of the variational parameters
}
