% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_files.R
\name{confirm_files}
\alias{confirm_files}
\title{Confirm files are identical to the ones published.}
\usage{
confirm_files(replicates_dir, violation, replicate_nums, version)
}
\arguments{
\item{replicates_dir}{Directory containing the replicates.
The name of the files must include the violation in Spanish and lower case
letters (homicidio, secuestro, reclutamiento, desaparicion).}

\item{violation}{Violation being analyzed. Options are "homicidio", "secuestro",
"reclutamiento", and "desaparicion".}

\item{replicate_nums}{A numeric vector containing the replicates to be analyzed.
Values in the vector should be between 1 and 100 inclusive.}

\item{version}{Version of the data being read in. Options are "v1" or "v2".
"v1" is appropriate for replicating the replicating the results of the joint
JEP-CEV-HRDAG project. "v2" is appropriate for conducting your new analyses
of the conflict in Colombia.}
}
\value{
A data frame row with \code{replicate_num} rows and two columns:
\code{replicate_path}, a string indicating the path to the replicate checked and
\code{confirmed}, a boolean values indicating whether the replicate contents match
the published version.
}
\description{
Confirm files are identical to the ones published.
}
\examples{
local_dir <- system.file("extdata", "right", package = "verdata")
confirm_files(local_dir, "reclutamiento", c(1, 2), version = "v1")
}
