% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Heart}
\alias{Heart}
\title{Sex, Occupation and Heart Disease}
\format{
A 3-dimensional array resulting from cross-tabulating 3 variables
for 21522 observations. The variable names and their levels are:

\tabular{rll}{
No \tab Name \tab Levels \cr
1\tab \code{Disease}\tab \verb{"Disease", "None"}\cr
2\tab \code{Gender}\tab \verb{"Male", "Female"}\cr
3\tab \code{Occup}\tab \verb{"Unempl", "WhiteCol", "BlueCol"}\cr
}
}
\source{
\% \cite{Karger, 1980}
Karger, (1980).
}
\description{
Classification of individuals by gender, occupational category and
occurrence of heart disease
}
\examples{

data(Heart)
str(Heart)

# Display the frequencies for occupational categories.
# Each row is a 2 x 2 table
vcd::structable(Disease + Gender ~ Occup, data=Heart)

# display as fourfold plots
vcd::cotabplot(~ Disease + Gender | Occup, data=Heart, panel = cotab_fourfold)

}
\keyword{datasets}
