% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-vasicekmean.R
\name{VASIM}
\alias{VASIM}
\alias{dVASIM}
\alias{pVASIM}
\alias{qVASIM}
\alias{rVASIM}
\title{Vasicek distribution with mean parameterization}
\usage{
dVASIM(x, mu, sigma, log = FALSE)

pVASIM(q, mu, sigma, lower.tail = TRUE, log.p = FALSE)

qVASIM(p, mu, sigma, lower.tail = TRUE, log.p = FALSE)

rVASIM(n, mu, sigma)

VASIM(mu.link = "logit", sigma.link = "logit")
}
\arguments{
\item{x, q}{Vector of quantiles in the interval \eqn{(0,1)}.}

\item{mu}{Vector of mean values.}

\item{sigma}{Vector of shape parameter values.}

\item{log, log.p}{Logical; if \code{TRUE}, probabilities are given on
the log scale.}

\item{lower.tail}{Logical; if \code{TRUE}, probabilities
\eqn{P(X \le x)} are returned.}

\item{p}{Vector of probabilities.}

\item{n}{Number of observations.}

\item{mu.link}{Link function for the \eqn{\mu} parameter.}

\item{sigma.link}{Link function for the \eqn{\sigma} parameter.}
}
\value{
\code{VASIM()} returns a \code{gamlss.family} object.
}
\description{
The function \code{VASIM()} defines the Vasicek distribution under
a mean-based parameterization for use as a
\code{gamlss.family} object in GAMLSS models. In this formulation,
\eqn{\mu} represents the mean of the distribution and
\eqn{\sigma} is a shape parameter. The functions \code{dVASIM},
\code{pVASIM}, \code{qVASIM}, and \code{rVASIM} provide the density,
distribution, quantile, and random generation functions,
respectively.
}
\details{
The probability density function is given by
\deqn{f(x \mid \mu, \sigma) =
\sqrt{\frac{1-\sigma}{\sigma}}
\exp\left\{\frac{1}{2}\left[\Phi^{-1}(x)^2 -
\left(\frac{\Phi^{-1}(x)\sqrt{1-\sigma}-\Phi^{-1}(\mu)}
{\sqrt{\sigma}}\right)^2\right]\right\}.}

The cumulative distribution function is
\deqn{F(x \mid \mu, \sigma) =
\Phi\left(\frac{\Phi^{-1}(x)\sqrt{1-\sigma}-\Phi^{-1}(\mu)}
{\sqrt{\sigma}}\right).}

The quantile function is
\deqn{Q(\tau \mid \mu, \sigma) =
\Phi\left(\frac{\Phi^{-1}(\mu)+\Phi^{-1}(\tau)\sqrt{\sigma}}
{\sqrt{1-\sigma}}\right).}
}
\note{
In the \code{VASIM()} parameterization, \eqn{\mu} corresponds to the
mean of the distribution and \eqn{\sigma} is a shape parameter.
}
\examples{
set.seed(123)
x <- rVASIM(n = 1000, mu = 0.5, sigma = 0.69)

hist(x, probability = TRUE, main = "Vasicek distribution")

\dontrun{
library(gamlss)
data <- data.frame(y = x[1:100])
fit <- gamlss(y ~ 1, data = data,
              family = VASIM(mu.link = "logit",
                             sigma.link = "logit"))
summary(fit)
}
}
\references{
Hastie, T. J. and Tibshirani, R. J. (1990).
\emph{Generalized Additive Models}. Chapman and Hall, London.

Mazucheli, J., Alves, B., Korkmaz, M.Ç., and Leiva, V. (2022).
Vasicek quantile and mean regression models for bounded data:
New formulation, mathematical derivations, and numerical applications.
\emph{Mathematics}, \bold{10}, 1389.
\doi{10.3390/math10091389}

Rigby, R. A. and Stasinopoulos, D. M. (2005).
Generalized additive models for location, scale and shape
(with discussion). \emph{Applied Statistics}, \bold{54}(3), 507--554.

Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and
De Bastiani, F. (2019).
\emph{Distributions for Modeling Location, Scale, and Shape:
Using GAMLSS in R}. Chapman and Hall/CRC.

Stasinopoulos, D. M. and Rigby, R. A. (2007).
Generalized additive models for location, scale and shape (GAMLSS)
in R. \emph{Journal of Statistical Software}, \bold{23}(7), 1--45.

Stasinopoulos, D. M., Rigby, R. A., Heller, G., Voudouris, V.,
and De Bastiani, F. (2017).
\emph{Flexible Regression and Smoothing: Using GAMLSS in R}.
Chapman and Hall/CRC.

Vasicek, O. A. (1987).
Probability of loss on loan portfolio. \emph{KMV Corporation}.

Vasicek, O. A. (2002).
The distribution of loan portfolio value.
\emph{Risk}, \bold{15}(12), 1--10.
}
\seealso{
\code{\link[vasicekreg]{VASIQ}}, \code{\link[mvtnorm]{pmvnorm}}
}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Bruna Alves \email{pg402900@uem.br}
}
