uncertainty.default <- function(x, y, ...) {
## this is the uncertainty estimator constructor
	if (!inherits(x, "uncertaintyBudget")) {
	  stop("x must be an uncertainty budget object")
	}
	if (y$method == "MC") {
		res <- .internal_mc(name = y$measurand_name, label = y$measurand_label,
		                    model = y$measurand_model, description = y$measurand_description,
					ub = x, alpha = y$alpha, B = y$B, 
					use.correlation  = y$use.correlation)
	} else if (y$method == "GFO") {
		res <- .internal_gfo(name = y$measurand_name, label = y$measurand_label,
		                     model = y$measurand_model, description = y$measurand_description,
					ub = x, alpha = y$alpha,
					use.correlation = y$use.correlation)
	} else if (y$method == "GSO") {
		res <- .internal_gso(name = y$measurand_name, label = y$measurand_label,
		                     model = y$measurand_model, description = y$measurand_description,
					ub = x, alpha = y$alpha,
					use.correlation = y$use.correlation)
#	} else if (y$method == "Kragten") {
#		res <- .internal_kragten(name = y$measurand_name, label = y$measurand_label,
#		                         model = y$measurand_model, description = y$measurand_description,
#					ub = x, alpha = y$alpha,
#					use.correlation = y$use.correlation)
	} else {
		stop("estimation methods available are (GFO, GSO, MC)")
	}
	class(res) <- "uncertainty"
	return( res )
}
