% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_header.R
\name{tt_header_above}
\alias{tt_header_above}
\title{Add grouped header row above column names}
\usage{
tt_header_above(
  table,
  header,
  bold = TRUE,
  align = "center",
  color = NULL,
  fill = NULL,
  italic = NULL,
  font_size = NULL,
  rotate = NULL,
  inset = NULL,
  stroke = NULL,
  line = TRUE,
  gap = "10pt"
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{header}{Named vector specifying header groups. Names are the group labels,
values are the number of columns each group spans. Use empty string \code{""} for
columns without a group header.}

\item{bold}{Logical. Make header text bold (default TRUE).}

\item{align}{Header alignment (default "center").}

\item{color}{Text color.}

\item{fill}{Fill color.}

\item{italic}{Logical. Make header text italic.}

\item{font_size}{Font size.}

\item{rotate}{Rotation angle (e.g., \code{"90deg"}, \code{90}, \code{"1.5rad"}).}

\item{inset}{Cell padding (e.g., \code{"10pt"}, \code{"5pt 8pt"}).}

\item{stroke}{Stroke (border) specification for the header cell(s). Can be \code{TRUE}
for default 1pt black, a color, a Typst stroke spec like \code{"2pt + blue"}, or a
Typst dictionary like \code{"(bottom: 1pt)"}.}

\item{line}{Logical. Add horizontal line below the header (default TRUE).}

\item{gap}{Width of visual gap between header groups (e.g., "10pt", "0.5em").
When specified, empty columns are inserted between groups. Default "10pt".
Use NULL to disable gaps.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Adds a spanning header row above the existing column names to group related
columns together.
}
\examples{
# Group columns under headers
tt(mtcars[1:5, 1:6], rownames = FALSE) |>
  tt_header_above(c("Performance" = 3, "Design" = 3))

# Leave some columns ungrouped
tt(mtcars[1:5, 1:6], rownames = FALSE) |>
  tt_header_above(c(" " = 1, "Group A" = 2, "Group B" = 3))

# Disable gaps between groups
tt(mtcars[1:5, 1:6], rownames = FALSE) |>
  tt_header_above(c(" " = 1, "Group A" = 2, "Group B" = 3), gap = NULL)

}
