% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{distribution_list}
\alias{distribution_list}
\title{Multiple Distributions}
\usage{
distribution_list(distributions = NULL, names = NULL)
}
\arguments{
\item{distributions}{a list with \sQuote{tsmodel.distribution} objects.}

\item{names}{an optional vector of names for each slot in the list.}
}
\value{
an object of class \sQuote{tsmodel.distribution_list}
}
\description{
validates and returns an object of class \sQuote{tsmodel.distribution_list} 
which holds a validated list of tsmodel.distribution objects for use in 
multivariate models.
}
\details{
The function will validate the distributions passed as belonging to class
\sQuote{tsmodel.distribution}, check whether they are similar in terms
of number of draws (rows), horizon (columns) and dates. If the list is not
named, then unless the \dQuote{names} argument is passed, then will name
the slots as series1, series2, etc.
}
\examples{
x1 <- matrix(rnorm(100), 10, 10)
colnames(x1) <- as.character(as.Date(1:10, origin = "1970-01-01"))
x2 <- matrix(rnorm(100), 10, 10)
colnames(x2) <- as.character(as.Date(1:10, origin = "1970-01-01"))
class(x1) <- class(x2) <- "tsmodel.distribution"
distributions <- list(s1 = x1, s2 = x2)
L <- distribution_list(distributions)
str(L)
}
