% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.3.0.R
\name{tslm}
\alias{tslm}
\alias{print.tslm}
\alias{summary.tslm}
\title{Generate Time Series Regression Model}
\usage{
tslm(
  x,
  trend.order = 1,
  seasonal = FALSE,
  period = NA,
  type = c("additive", "multiplicative"),
  train.prop = 1
)

\method{print}{tslm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{tslm}(
  object,
  anova = TRUE,
  digits = max(3L, getOption("digits") - 3L),
  se = TRUE,
  signif.stars = TRUE,
  ...
)
}
\arguments{
\item{x}{a univariate time series or a `\code{tslm}` object.}

\item{trend.order}{an integer specifying the polynomial order of the trend line estimation. If \code{trend.order = 0}, no trend component will be included in the model. Default is 1.}

\item{seasonal}{logical. If \code{TRUE}, seasonal component will be included in the model. Default is \code{FALSE}.}

\item{period}{a numerical value specifying the seasonal cycle length of the series. If omitted, \code{frequency(x)} will be used here. Only effective if \code{seasonal = TRUE}. Default is \code{NA}.}

\item{type}{string characters specifying the series type. Available options are `\code{additive}` and `\code{multiplicative}`. If `\code{type = multiplicative}`, interaction terms between trend and seasonal components will be added to the model. Default is `\code{additive}`.}

\item{train.prop}{a numerical value specifying the proportion of training data in the series. The value must be between 0 and 1. Default is \code{1}.}

\item{digits}{the number of significant digits to use when printing}

\item{...}{other printing or summary parameters.}

\item{object}{a \code{tslm} object for summary}

\item{anova}{logical. If \code{TRUE}, an anova table with significance tests for trend, seasonality and their interaction will be included in the summary.}

\item{se}{logical. If \code{TRUE}, standard error will be included in displaying the result. Default is \code{TRUE}.}

\item{signif.stars}{logical. If \code{TRUE}, `significance stars` are printed for each coefficient}
}
\value{
An object of class `\code{tslm}` is a list containing at least the following components:

\item{coefficients}{a named vector of coefficients}

\item{residuals}{the residuals, that is response minus fitted values}

\item{rank}{the numeric rank of the fitted linear model}

\item{fitted.values}{the fitted mean values}

\item{df.residual}{the residual degrees of freedom}

\item{call}{the matched call}

\item{terms}{the terms object used}

\item{xlevels}{(only where relevant) a record of the levels of the factors used in fitting}

\item{offset}{the offset used (missing if none were used)}

\item{model}{if requested (the default), the model frame used}

\item{train.prop}{proportion of training data.}

\item{x}{data of the original series.}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{x.time.used}{list of time in which the series values were used for model fitting. It will be the same as \code{x.time} if \code{train.prop = 1}.}

\item{x.used}{data of the original series which were used for model fitting. It will be the same as \code{x} if \code{train.prop = 1}.}

\item{series}{series name \code{x} in match call.}

\item{error}{a list of prediction error estimators, including \code{$ME} for mean error, \code{$RMSE} for root mean squared error, \code{$MAE} for mean absolute error, \code{$MPE} for mean percentage error, \code{$MAPE} for mean absolute percentage error, \code{$MASE} for mean absolute scaled error, \code{$MASE.S} for seasonal mean absolute scaled error, and \code{$ACF1} for lag 1 autocorrelation.}

\item{model.test}{a list of information regarding the prediction of the testing data including `\code{x.test}` (part of `\code{x}` used for testing), `\code{fitted.test}` (predicted values of the testing data), `\code{residuals.test}` (prediction error of the testing data), and `\code{error.test}` (prediction error measurements based on the testing data). Only available if \code{train.prop} is smaller than 1.}
}
\description{
Fit Time Series Regression Models.
}
\examples{
tslm(airport$Travellers, trend.order = 2, 
     seasonal = TRUE, type = "multiplicative")
}
\references{
Hyndman, R. J., Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
