% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{deduplicate}
\alias{deduplicate}
\title{Concatenate and deduplicate vectors}
\usage{
deduplicate(..., merge = FALSE)
}
\arguments{
\item{...}{One or more vectors of any mode, usually named.}

\item{merge}{If \code{FALSE}, the default, duplicate elements will simply
be discarded. If \code{TRUE}, additional elements with the same name will
be appended to the retained one. This does not apply to unnamed elements.
If this kind of deduplication actually happens, the return value will be a
list, regardless of the source type.}
}
\value{
The concatenated and deduplicated vector.
}
\description{
This function returns its arguments, after concatenating them using \code{c}
and then removing elements with duplicate names. The first element with each
name will remain, possibly with subsequent elements' content appended to it.
Unnamed elements are retained.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\author{
Jon Clayden
}
