\encoding{utf8}
\name{tost.mcci}
\alias{Immediate paired z test for equivalence of marginal probabilities in binary data}
\alias{tost.mcci}
\concept{paired z tests for proportion-equivalence}
\concept{Two One-Sided Tests}
\title{Immediate paired \emph{z} test for equivalence of marginal probabilities in binary data}
\description{
  \loadmathjax
  Immediately performs two one-sided \emph{z} tests for equivalence of marginal probabilities in binary data}
\usage{
tost.mcci(
    a = NA, b = NA, c = NA, d = NA,
    eqv.type    = equivalence.types,
    eqv.level   = 1, 
    upper       = NA,
    ccontinuity = continuity.correction.methods, 
    conf.level  = 0.95, 
    relevance   = TRUE)

equivalence.types 
#c("delta", "epsilon")

continuity.correction.methods 
#c("none", "yates", "edwards")
}
\arguments{
 \item{a}{a non-negative integer indicating the number of paired observations with both cases and controls exposed.}
 \item{b}{a non-negative integer indicating the number of paired observations with cases exposed and controls unexposed.}
 \item{c}{a non-negative integer indicating the number of paired observations with cases unexposed and controls exposed.}
 \item{d}{a non-negative integer indicating the number of paired observations with both cases and controls unexposed.}
 \item{eqv.type}{defines whether the equivalence interval will be defined in terms of \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon} (\code{"delta"}, or \code{"epsilon"}). These options change the way that \code{evq.level} is interpreted: when \code{"delta"} is specified, the \code{evq.level} is expressed in the units of marginal probabilities being tested, and when \code{"epsilon"} is specified, the \code{evq.level} is measured in units of the \emph{z} distribution; put another way \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}. The default is \code{"delta"}.\cr \cr Defining tolerance in terms of \mjeqn{\varepsilon}{epsilon} means that it is not possible to reject any test for mean equivalence's \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\varepsilon \le z_{\nu,\alpha}}{epsilon <= the critical value of \emph{z} for a given \mjeqn{\alpha}{alpha} and degrees of freedom}. Because \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}, we can see that it is not possible to reject any \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\Delta \le \text{standard error} \times z_{\nu,\alpha}}{Delta <= the product of the standard error and critical value of \emph{z} for a given \mjeqn{\alpha}{alpha} and degrees of freedom}. \code{tost.mcci} reports when either of these conditions obtain.}
 \item{eqv.level}{defines the equivalence threshold for the tests depending on whether \code{eqv.type} is \code{"delta"} or \code{"epsilon"} (see above).  Researchers are responsible for choosing meaningful values of \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}. The default value is 1, which is not a useful value for either \code{eqv.type="delta"} or \code{eqv.type="epsilon"}.}
 \item{upper}{defines the upper equivalence threshold for the test, is assumed to be positive, and transforms the meaning of \code{eqv.level} to mean the \emph{lower} equivalence threshold for the test.  Also, \code{eqv.level} is assumed to be a negative value. Taken together, these correspond to Schuirmann's (1987) asymmetric equivalence intervals. If \code{upper==abs(eqv.level)}, then \code{upper} will be ignored.}
 \item{conf.level}{confidence level of the interval, and complement of the test's nominal type I error rate \mjeqn{\alpha}{alpha}.}
 \item{ccontinuity}{calculates test statistics for both positivist and negativist tests using a continuity correction. The default is \code{"none"}, users may select a Yates continuity correction using the \code{"yates"} option, or an Edwards continuity correction using the \code{"edwards"} option. The Yates continuity correction (Yates, 1934) uses the term \mjeqn{\left[\left(b - c\right)-\frac{1}{2}\right]}{[(\emph{b} -- \emph{c}) - 0.5]} for \mjeqn{z_1}{\emph{z}_1}, and the term \mjeqn{\left[\left(b - c\right) + \frac{1}{2}\right]}{[(\emph{b} -- \emph{c}) + 0.5]} for \mjeqn{z_2}{\emph{z}_2}.  The Edwards continuity correction (Edwards, 1947) uses the term \mjeqn{\left[\left(b - c\right)-1\right]}{[(\emph{b} -- \emph{c}) - 1]} for \mjeqn{z_1}{\emph{z}_1}, and the term \mjeqn{\left[\left(b - c\right) + 1\right]}{[(\emph{b} -- \emph{c}) + 1]} for \mjeqn{z_2}{\emph{z}_2}.}
 \item{relevance}{reports results and inference for combined tests for difference and for equivalence for a specific \code{conf.level}, \code{eqv.type}, \code{eqv.level}, and, if used, \code{upper}.  See the Remarks section more details on inference from combined tests.}
}
\details{Immediate commands perfom tests given summary statistics, rather than given data. \code{tost.mcci} tests for equivalence of the marginal probabilities of exposure in matched case-control data.  It calculates a Wald-type asymptotic \mjeqn{z}{\emph{z}} test (Liu, et al., 2002) in a two one-sided tests approach (Schuirmann, 1987).  \code{tost.mcc} is the non-immediate form of \code{tost.mcci}.  Typically the null hypotheses of the corresponding McNemar's \mjeqn{\chi^{2}}{chi-sq} test (McNemar, 1947) for difference in marginal probabilities are framed from an assumption of equality of marginal probability of exposure between cases and controls (e.g.,  \mjeqn{\text{H}^{+}_{0}: \frac{b}{n} - \frac{c}{n} = 0}{Ho+: \emph{b}/\emph{n} - \emph{b}/\emph{n} = 0}, rejecting this assumption only with sufficient evidence.  When performing tests for equivalence of marginal probabilities, the null hypothesis is framed as the difference in marginal probabilities is at least as much as the equivalence interval as defined by some chosen level of tolerance (as specified by \code{eqv.type} and \code{eqv.level}).

  
With respect to a \mjeqn{z}{\emph{z}} test, a negativist null hypothesis takes one of the following two forms depending on whether tolerance is defined in terms of \mjeqn{\Delta}{Delta} (equivalence expressed in the units of the marginal probability of counts of discordant pairs) or in terms of \mjeqn{\varepsilon}{epsilon} (equivalence expressed in the units of the \mjeqn{z}{\emph{z}} distribution):


\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }\left|\frac{b}{n} - \frac{c}{n}\right| \ge \Delta}{&nbsp;&nbsp;Ho: |\emph{b}/\emph{n} -- \emph{c}/\emph{n}| >= Delta},\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{\left(\frac{b}{n} - \frac{c}{n}\right) - \Delta}{(\emph{b}/\emph{n} -- \emph{c}/\emph{n})-Delta} to \mjeqn{\left(\frac{b}{n} - \frac{c}{n}\right) + \Delta}{(\emph{b}/\emph{n} -- \emph{c}/\emph{n})+Delta}, and where \mjeqn{b}{\emph{b}} is the count of pairs with cases exposed, but controls unexposed, and and \mjeqn{c}{\emph{c}} is the count of pairs with cases unexposed and controls exposed.  This translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{  H}_{01}^{-}\text{: }\frac{b}{n} - \frac{c}{n} \ge \Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} >= Delta}, or\cr
\emph{}\mjeqn{\phantom{2222}\text{  H}_{02}^{-}\text{: }\frac{b}{n} - \frac{c}{n} \le -\Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} <= Delta}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon ,}{&nbsp;&nbsp;Ho-: |\emph{Z}| >= epsilon,}\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{-\varepsilon}{--epsilon} to \mjeqn{\varepsilon}{epsilon}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1-: \emph{Z} >= epsilon}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le -\varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2-: \emph{Z} <= --epsilon}.

When an asymmetric equivalence interval is defined using the \code{upper} option the general negativist null hypothesis becomes:

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }\frac{b}{n} - \frac{c}{n} \le \Delta_{\text{lower}}}{&nbsp;&nbsp;Ho-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} <= Delta_lower}, or \mjeqn{\frac{b}{n} - \frac{c}{n} \ge \Delta_{\text{upper}}}{Ho-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} >= Delta_upper}\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{\left(\frac{b}{n} - \frac{c}{n}\right) + \Delta_{\text{lower}}}{(\emph{b}/\emph{n} -- \emph{c}/\emph{n}) + Delta_lower} to \mjeqn{\left(\frac{b}{n} - \frac{c}{n}\right) + \Delta_{\text{upper}}}{(\emph{b}/\emph{n} -- \emph{c}/\emph{n}) + Delta_upper}.  This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }\frac{b}{n} - \frac{c}{n} \ge \Delta_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} >= Delta_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }\frac{b}{n} - \frac{c}{n} \le \Delta_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2-: \emph{b}/\emph{n} -- \emph{c}/\emph{n} <= Delta_lower}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }Z \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;Ho: Z <= epsilon_lower}, or \mjeqn{Z \ge \varepsilon_{\text{upper}}}{Z >= epsilon_upper}, with:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1-: Z >= epsilon_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2-: Z <= epsilon_lower}.\cr
 
NOTE: the appropriate level of \mjeqn{\alpha = (1 - }{alpha =  (1 -- }\code{conf.level}\mjeqn{)}{)} is precisely the same as in the corresponding two-sided test for mean difference, so that, for example, if one wishes to make a type I error \%1 of the time, one simply conducts both of the one-sided tests of \mjeqn{\text{H}_{01}^{-}}{Ho1} and \mjeqn{\text{H}_{02}^{-}}{Ho2} by comparing the resulting p-value to 0.01 (Tryon and Lewis, 2008; Wellek, 2010).

\subsection{Remarks}{As described by Tryon and Lewis (2008), when rejection decisions from both tests for difference (e.g., \mjeqn{\text{H}_{0}^{+}\text{: }\frac{b}{n} - \frac{c}{n} = 0}{positivist Ho+: \emph{b}/\emph{n} -- \emph{c}/\emph{n} = 0} or \mjeqn{\text{H}^{+}_{0}\text{: Z = 0}}{}) and tests for equivalence (e.g., either \mjeqn{\text{H}_{0}^{-}\text{: }\left|\frac{b}{n} - \frac{c}{n}\right| \ge \Delta}{negativist Ho-: |\emph{b}/\emph{n} -- \emph{c}/\emph{n}| >= Delta}, or \mjeqn{\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon}{negativist Ho: |Z| >= epsilon}) are combined, there are four possible interpretations for a given \mjeqn{\alpha}{alpha} and \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}:

\enumerate{
\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but fail to reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{relevant difference} in marginal proportions at least as large as \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is \bold{equivalence} in marjinal proportions within the equivalence range (i.e. defined by \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}).

\item One may reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{trivial difference} in marjinal proportions which lies within the equivalence range (i.e. defined by \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}).

\item One may fail to reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and draw an \bold{indeterminate} conclusion, because the data are underpowered to detect either difference or equivalence.
}
}
}
\value{
\code{tost.mcci} returns:
 \item{statistics}{a vector containing the value of \mjeqn{z_{1}}{z1} and \mjeqn{z_{2}}{z_2}; if \code{relevance=TRUE}, these are followed by the value of the \emph{z} statistic for the postivist test for difference.}
 \item{p.values}{a vector of \emph{p} values for the \emph{z} tests.}
 \item{estimate}{the estimated difference in proportion with exposure.}
 \item{threshold}{a scalar containing the equivalence threshold when \code{eqv.type="delta"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="delta"}. A scalar containing the equivalence threshold when \code{eqv.type="epsilon"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="epsilon"}.}
 \item{conclusion}{relevance test conclusion for a given \mjeqn{\alpha}{\U03B1} and \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}.}
 }
\author{
Alexis Dinno (\email{alexis.dinno@pdx.edu})

Please contact me with any questions, bug reports or suggestions for improvement.  Fixing bugs will be facilitated by sending along:
\enumerate{
\item a copy of the data (de-labeled or anonymized is fine),\cr
\item a copy of the command syntax used, and\cr
\item a copy of the exact output of the command.\cr
}
\subsection{Suggested citation}{Dinno, A.  2025.  \bold{tost.mcci}: Paired \emph{z} test for equivalence of marginal probabilities in binary data.  In: \bold{tost.suite} R software package.}
}
\references{

Edwards, A.  (1948)  \href{https://pubmed.ncbi.nlm.nih.gov/18885738/}{Note on the ``correction for continuity'' in testing the significance of the difference between correlated proportions}.  \emph{Psychometrika} \bold{13}, 185--187.

Liu, J., et al., (2002)  \href{https://pubmed.ncbi.nlm.nih.gov/11782062/}{Tests for equivalence or non-inferiority for paired binary data}.  \emph{Statistics In Medicine} \bold{21}, 231--245.

McNemar, Q.  (1947)  \href{https://pubmed.ncbi.nlm.nih.gov/20254758/}{Note on the sampling error of the difference between correlated proportions or percentages}.  \emph{Psychometrika} \bold{12}, 153--157
 
Schuirmann, D.  A.  (1987) \href{https://pubmed.ncbi.nlm.nih.gov/3450848/}{A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}. \emph{Journal of Pharmacokinetics and Biopharmaceutics}. \bold{15}, 657--680.

Tryon, W. W., and C. Lewis. (2008) \href{https://pubmed.ncbi.nlm.nih.gov/18778155/}{An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}. \emph{Psychological Methods}. \bold{13}, 272--277

Yates, F.  (1934)  \href{https://www.jstor.org/stable/2983604}{Contingency tables involving small numbers and the \mjeqn{\chi^2}{chi-squared} test}.  \emph{Supplement to the Journal of the Royal Statistical Society}. \bold{1}, 217--235.

Wellek, S.  (2010)  \href{https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184}{\emph{Testing Statistical Hypotheses of Equivalence and Noninferiority}}, second edition. Chapman and Hall/CRC Press. p. 31}
\seealso{
  \code{\link{mcnemar.test}}, \code{\link{tost.mcc}}.
}
\examples{
# Immediate command for the relevance test in paired binary data in the help file
# for tost.mcc
tost.mcci(
    a=8, b=8, c=3, d=8, 
    eqv.type="delta", 
    eqv.level=.2, 
    relevance=TRUE)

# Different example with an asymetric interval; the lower end of the equivalence
# interval = qnorm(.95)+.5 = 2.144854 meaning equivalence must lay no more
# than 0.5 sd beyond the critical value of Z for alpha = 0.05.  The upper end of
# the equivalence interval = qnorm(.95)+1 = 2.644854 meaning equivalence
# must lay no more than 1 sd beyond the critical value of Z for alpha = 0.05.
tost.mcci(
    a=4, b=9, c=8, d=5, 
    eqv.type="epsilon", 
    eqv.level=qnorm(.95)+.5, 
    upper=qnorm(.95)+1, 
    relevance=TRUE)
}
\keyword{htest}
\keyword{stats}
