% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-efficientnet.R
\name{model_efficientnet}
\alias{model_efficientnet}
\alias{model_efficientnet_b0}
\alias{model_efficientnet_b1}
\alias{model_efficientnet_b2}
\alias{model_efficientnet_b3}
\alias{model_efficientnet_b4}
\alias{model_efficientnet_b5}
\alias{model_efficientnet_b6}
\alias{model_efficientnet_b7}
\title{EfficientNet Models}
\usage{
model_efficientnet_b0(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b1(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b2(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b3(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b4(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b5(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b6(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_b7(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{...}{Other parameters passed to the model implementation, such as
\code{num_classes} to change the output dimension.}
}
\description{
Constructs EfficientNet model architectures as described in
\emph{EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}.
These models are designed for image classification tasks and provide a balance
between accuracy and computational efficiency through compound scaling.
}
\section{Functions}{
\itemize{
\item \code{model_efficientnet_b0()}: EfficientNet B0 model

\item \code{model_efficientnet_b1()}: EfficientNet B1 model

\item \code{model_efficientnet_b2()}: EfficientNet B2 model

\item \code{model_efficientnet_b3()}: EfficientNet B3 model

\item \code{model_efficientnet_b4()}: EfficientNet B4 model

\item \code{model_efficientnet_b5()}: EfficientNet B5 model

\item \code{model_efficientnet_b6()}: EfficientNet B6 model

\item \code{model_efficientnet_b7()}: EfficientNet B7 model

}}
\section{Task}{

Image classification with 1000 output classes by default (ImageNet).
}

\section{Input Format}{

The models expect input tensors of shape \code{(batch_size, 3, H, W)}, where H and W
should typically be 224 for B0 and scaled versions for B1–B7 (e.g., B7 uses 600x600).
}

\section{Variants and Scaling}{

\tabular{lllllll}{
\strong{Model} \tab \strong{Width} \tab \strong{Depth} \tab
\strong{Resolution} \tab \strong{Params (M)} \tab \strong{GFLOPs} \tab
\strong{Top-1 Acc.} \cr
B0 \tab 1.0 \tab 1.0 \tab 224 \tab 5.3 \tab 0.39 \tab 77.1 \cr
B1 \tab 1.0 \tab 1.1 \tab 240 \tab 7.8 \tab 0.70 \tab 79.1 \cr
B2 \tab 1.1 \tab 1.2 \tab 260 \tab 9.2 \tab 1.00 \tab 80.1 \cr
B3 \tab 1.2 \tab 1.4 \tab 300 \tab 12.0 \tab 1.80 \tab 81.6 \cr
B4 \tab 1.4 \tab 1.8 \tab 380 \tab 19.0 \tab 4.20 \tab 82.9 \cr
B5 \tab 1.6 \tab 2.2 \tab 456 \tab 30.0 \tab 9.90 \tab 83.6 \cr
B6 \tab 1.8 \tab 2.6 \tab 528 \tab 43.0 \tab 19.0 \tab 84.0 \cr
B7 \tab 2.0 \tab 3.1 \tab 600 \tab 66.0 \tab 37.0 \tab 84.3
}
}

\examples{
\dontrun{
model <- model_efficientnet_b0()
image_batch <- torch::torch_randn(1, 3, 224, 224)
output <- model(image_batch)
imagenet_label(which.max(as.numeric(output)))
}

\dontrun{
# Example of using EfficientNet-B5 with its native image size
model <- model_efficientnet_b5()
image_batch <- torch::torch_randn(1, 3, 456, 456)
output <- model(image_batch)
imagenet_label(which.max(as.numeric(output)))
}

}
\seealso{
Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_convnext}},
\code{\link{model_efficientnet_v2}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_mobilenet_v3}},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}
}
\concept{classification_model}
