% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_toon.R
\name{as_toon}
\alias{as_toon}
\alias{print.toon}
\title{Convert R Objects to TOON (Token-Oriented Object Notation)}
\usage{
as_toon(x, ...)

\method{print}{toon}(x, ...)
}
\arguments{
\item{x}{The R object to be converted. Supported types include:
\itemize{
  \item Named lists
  \item Unnamed lists and atomic vectors
  \item Data frames
  \item Primitive types (numeric, character, logical, NULL)
}}

\item{...}{Additional arguments passed to specific S3 methods (e.g., internal
indentation parameters).}
}
\value{
A character vector of class \code{toon}, containing the fully 
formatted TOON string.
}
\description{
Converts a variety of R objects, including named lists (objects),
unnamed lists, vectors (arrays), and data frames, into a character string
formatted according to TOON (Token-Oriented Object Notation) specification.
}
\details{
TOON is designed as a highly human-readable, lightweight data serialization
format that supports nested structures.
}
\examples{
# 1. Simple Object (Named List)
config_obj <- list(
  version = 1.0,
  is_active = TRUE,
  user_id = 99
)
as_toon(config_obj)

# 2. Expanded Array (Unnamed List)
items <- list(
  "apple",
  list(color = "red", weight = 150),
  "banana"
)
as_toon(items)

# 3. Data Frame
df <- data.frame(
  time = c(9.1, 15.4),
  action = c("login", "update"),
  success = c(TRUE, FALSE)
)
as_toon(df)
}
