% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissot.R
\name{plot.indicatrix}
\alias{plot.indicatrix}
\title{Plot an indicatrix}
\usage{
\method{plot}{indicatrix}(
  x,
  scale = 1e+05,
  n = 72,
  col = "#FF990055",
  border = "black",
  add = TRUE,
  show.axes = TRUE,
  show.circle = TRUE,
  ...
)
}
\arguments{
\item{x}{an \code{indicatrix} object (from \code{\link[=indicatrix]{indicatrix()}})}

\item{scale}{scaling factor for the ellipse size in projected units}

\item{n}{number of points on the ellipse}

\item{col}{fill colour for the ellipse}

\item{border}{border colour}

\item{add}{logical; add to existing plot?}

\item{show.axes}{\code{TRUE}, \code{FALSE}, or a named list of graphical parameters
for the direction lines. Defaults: \code{list(col.lambda = "red", col.phi = "blue", lwd = 1.5)}.}

\item{show.circle}{\code{TRUE}, \code{FALSE}, or a named list of graphical parameters
for the reference circle. Defaults: \code{list(col = adjustcolor("white", alpha.f = 0.6), border = "grey70", lwd = 2.5, lty = 2)}.}

\item{...}{passed to \code{\link[graphics:polygon]{graphics::polygon()}}}
}
\value{
The input \code{x}, invisibly.
}
\description{
Draws a single Tissot indicatrix ellipse on the current plot. The ellipse
shows the distortion of a unit circle under the map projection. Optional
overlays include a reference unit circle, and lambda/phi direction axes.
}
\details{
\code{show.circle} and \code{show.axes} accept \code{TRUE} (use defaults), \code{FALSE}
(hide), or a named list of graphical parameters to override defaults.
For example, \code{show.circle = list(border = "blue", lty = 3)}.
}
\seealso{
\code{\link[=indicatrix]{indicatrix()}}, \code{\link[=plot.indicatrix_list]{plot.indicatrix_list()}}, \code{\link[=ti_ellipse]{ti_ellipse()}}
}
