% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendrical-computations}
\alias{calendrical-computations}
\alias{nth_day_of_year}
\alias{last_day_in_month}
\alias{last_day_in_quarter}
\alias{nth_dw_in_month}
\alias{last_dw_in_month}
\alias{nth_dw_after}
\alias{nth_dw_before}
\alias{easter}
\title{Calendrical Computations in \pkg{tind} Package}
\usage{
nth_day_of_year(nth, y)

last_day_in_month(m)

last_day_in_quarter(q)

nth_dw_in_month(nth, dw, m)

last_dw_in_month(dw, m)

nth_dw_after(nth, dw, d)

nth_dw_before(nth, dw, d)

easter(y)
}
\arguments{
\item{nth}{a numeric value or vector of indices (1--366 for \code{nth_day_of_year},
1--5 for \code{nth_dw_in_month}). A positive integer (vector) for
\code{nth_dw_after} and \code{nth_dw_before}.}

\item{y, q, m, d}{an object of \code{tind} class or an R object coercible to it.}

\item{dw}{a numeric value or vector of days of week (values in range 1--7
with Monday as the 1st day).}
}
\value{
An object of \code{tind} class with dates (type \code{"d"}).
}
\description{
The following functions can be used for calendrical computations, especially
determining dates of movable observances. All function are vectorised.

\code{nth_day_of_year} returns the date of the nth day of a year.

\code{last_day_in_month} and \code{last_day_in_quarter} return the date
of the last day in a month or a quarter.

\code{nth_dw_in_month} returns the date of the nth day
of week in a month.

\code{last_dw_in_month} returns the date of the last day
of week in a month.

\code{nth_dw_after} and \code{nth_dw_before} calculate the nth occurrence
of a day of week after or before given date.

\code{easter} returns the date of Easter in a year.
}
\examples{
# Thanksgiving in the US is observed on the fourth Thursday of November,
# which in 2019 was on:
nth_dw_in_month(4, 4, 201911)
# and Black Friday?
nth_dw_in_month(4, 4, 201911) + 1

# Daylight Saving Time in the EU in 2019 began on the last Sunday in March,
# which was on:
last_dw_in_month(7, 201903)

# International Monetary Market dates in 2022 - 3rd Wednesday
# of March, June, September, and December
nth_dw_in_month(3, 3, tind(y = 2022, m = 3 * 1:4))

# determine frequencies of Easter months over the last 100 years
# Easter months
em <- month(easter(as.year(today()) + (-99:0)), labels = TRUE)
# table and barplot
table(em) / length(em) * 100
if (require("graphics", quietly = TRUE)) {
    barplot(table(em) / length(em) * 100, ylim = c(0, 100), col = "#faf06d")
}

}
\seealso{
\link{time-index-components}, \link{time-index-properties},
\link{Ops}. Further examples of application of these functions
can be found in \code{\link{calendar}} documentation. For calendrical
computations involving business days see \code{\link{bizday}}.
}
