% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlgsetup.R
\name{tlgsetup}
\alias{tlgsetup}
\title{Setup data to support the specified column type}
\usage{
tlgsetup(
  df,
  var,
  column_metadata_file = NULL,
  column_metadata = NULL,
  tbltype = NULL
)
}
\arguments{
\item{df}{dataframe of records for analysis.}

\item{var}{character vector that identifies the numeric column/treatment
variable.}

\item{column_metadata_file}{A file containing the column metadata. Read in
with \code{readxl::read_excel()}. If a \code{column_metadata} dataframe is passed in
too, this is ignored.}

\item{column_metadata}{A dataframe containing the column metadata. This will
be used in place of \code{column_metadata_file}.}

\item{tbltype}{A value used to subset the \code{column_metadata}, both this
and the file requirements are needed to bind the data to the table.}
}
\value{
dataframe with observations added to support the column type as well
as the factor variable \code{colnbr} which is used as our new column summary
variable. Regardless of if a \code{coldef} exists in data,
the column will exist in the table.
}
\description{
\code{tlgsetup} is useful for preprocessing total columns and columns composed of
other columns. \code{tlgsetup} is called internally by \code{generate_results()}
and can be run manually for custom tables.
}
\examples{
df <-
  tibble::tribble(
    ~TRT01AN, ~USUBJID,
    0, "A",
    54, "B",
    81, "C"
  )

tlgsetup(df, "TRT01AN", column_metadata = column_metadata)

# Using a dataframe of column metadata
column_metadata <-
  tibble::tribble(
    ~tbltype, ~coldef, ~decode,                ~span1,
    "type1",  "0",     "Placebo",              "",
    "type1",  "54",    "Low Dose",             "Xanomeline",
    "type1",  "81",    "High Dose",            "Xanomeline",
    "type1",  "54+81", "Total Xanomeline",     ""
  )

tlgsetup(df, "TRT01AN", column_metadata = column_metadata)
}
