% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_loci.R
\name{select_loci}
\alias{select_loci}
\title{The \code{select} verb for \code{loci}}
\usage{
select_loci(.data, .sel_arg)
}
\arguments{
\item{.data}{a \code{gen_tibble}}

\item{.sel_arg}{one unquoted expression, using the mini-grammar of
\code{\link[dplyr:select]{dplyr::select()}} to select loci. Variable names
can be used as if they were positions in the data frame, so expressions
like x:y can be used to select a range of variables.}
}
\value{
a \code{gen_tibble} with a subset of the loci.
}
\description{
An equivalent to \code{\link[dplyr:select]{dplyr::select()}} that works on the \code{genotype} column
of a \code{gen_tibble}, using the mini-grammar available for \code{tidyselect}. The
\code{select}-like evaluation only has access to the names of the loci (i.e. it
can select only based on names, not summary statistics of those loci; look
at \code{\link[=select_loci_if]{select_loci_if()}} for that feature.
}
\details{
Note that the \code{select_loci} verb does not modify the backing FBM files,
but rather it subsets the list of loci to be used stored in the \code{gen_tibble}.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Select loci by name
example_gt_subset <- example_gt \%>\%
  select_loci(all_of(c("rs1", "rs2", "rs3")))
show_loci(example_gt_subset)

# Select loci by index
example_gt_subset <- example_gt \%>\% select_loci(all_of(c(4, 2, 1)))
show_loci(example_gt_subset)

}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}
}
