% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_matrix.R
\name{get_p_matrix}
\alias{get_p_matrix}
\title{Return a single P matrix from a \code{gt_admix} object}
\usage{
get_p_matrix(x, ..., k, run)
}
\arguments{
\item{x}{A \code{gt_admix} object containing P matrices}

\item{...}{Not used}

\item{k}{The k value of the desired P matrix}

\item{run}{The run number of the desired P matrix}
}
\value{
A single P matrix from the \code{gt_admix} object
}
\description{
This function retrieves a single P matrix from a \code{gt_admix} object
based on the specified k value and run number.
}
\examples{
# Read example gt_admix object
admix_obj <-
  readRDS(system.file("extdata", "anolis", "anole_adm_k3.rds",
    package = "tidypopgen"
  ))

# Extract a P matrix
get_p_matrix(admix_obj, k = 3, run = 1)
}
