% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation-indices.R
\name{calculate_CDD}
\alias{calculate_CDD}
\title{Calculate consecutive dry days (CDD)}
\usage{
calculate_CDD(
  df,
  frequency = "daily",
  time_col = NULL,
  prcp_col = NULL,
  precip_col = NULL,
  dry_threshold = 1
)
}
\arguments{
\item{df}{Data frame with precipitation data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). Must be in a format recognizable by lubridate
(e.g., Date for daily data, POSIXct for hourly data). Recommended formats:
- Daily: YYYY-MM-DD (e.g., "2023-01-15")
- Hourly: YYYY-MM-DD HH:MM:SS (e.g., "2023-01-15 14:30:00")}

\item{prcp_col}{Name of precipitation column (daily data) (string)}

\item{precip_col}{Name of precipitation column (hourly data) (string)}

\item{dry_threshold}{Threshold for dry day in mm (default: 1)}
}
\value{
A data.frame with columns: year, CDD_max, CDD_mean, CDD_median, n_dry_spells
}
\description{
Calculates statistics for dry spells (consecutive days with
precipitation < 1 mm), following ETCCDI definition CDD.
}
\examples{
# Daily precipitation data
daily_prcp <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  rainfall = pmax(0, rgamma(1096, shape = 0.5, scale = 10))
)

# Calculate consecutive dry days statistics
calculate_CDD(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall"
)

# With custom dry threshold (0.5mm instead of 1mm)
calculate_CDD(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall",
  dry_threshold = 0.5
)
}
