% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-seg_basket.R,
%   R/class-seg_cpt.R, R/class-tidycpt.R, R/pkg-GA.R, R/pkg-changepoint.R,
%   R/pkg-changepointGA.R, R/pkg-segmented.R, R/pkg-strucchange.R, R/pkg-wbs.R,
%   R/utils.R
\name{as.segmenter}
\alias{as.segmenter}
\alias{as.seg_cpt}
\alias{as.seg_cpt.seg_basket}
\alias{as.seg_cpt.seg_cpt}
\alias{as.segmenter.tidycpt}
\alias{as.seg_cpt.ga}
\alias{as.seg_cpt.cpt}
\alias{as.seg_cpt.cptga}
\alias{as.seg_cpt.segmented}
\alias{as.seg_cpt.breakpointsfull}
\alias{as.seg_cpt.wbs}
\alias{is_segmenter}
\title{Convert, retrieve, or verify a segmenter object}
\usage{
as.segmenter(object, ...)

as.seg_cpt(object, ...)

\method{as.seg_cpt}{seg_basket}(object, ...)

\method{as.seg_cpt}{seg_cpt}(object, ...)

\method{as.segmenter}{tidycpt}(object, ...)

\method{as.seg_cpt}{ga}(object, ...)

\method{as.seg_cpt}{cpt}(object, ...)

\method{as.seg_cpt}{cptga}(object, ...)

\method{as.seg_cpt}{segmented}(object, ...)

\method{as.seg_cpt}{breakpointsfull}(object, ...)

\method{as.seg_cpt}{wbs}(object, ...)

is_segmenter(object, ...)
}
\arguments{
\item{object}{A \linkS4class{tidycpt} or \code{segmenter} object}

\item{...}{Arguments passed to methods}
}
\value{
\itemize{
\item \code{\link[=as.segmenter]{as.segmenter()}} returns the \code{segmenter} object of a \code{tidycpt} object.
Note that this could be of
any class, depending on the class returned by the segmenting function.
}

\itemize{
\item \code{\link[=as.seg_cpt]{as.seg_cpt()}} returns a \link{seg_cpt} object
}

\itemize{
\item \code{\link[=is_segmenter]{is_segmenter()}} a \code{logical} vector of length 1
}
}
\description{
Convert, retrieve, or verify a segmenter object
}
\details{
\linkS4class{tidycpt} objects have a \code{segmenter} component (that is typically
created by a class to \code{\link[=segment]{segment()}}).
The functions documented here are convenience utility functions
for working with the \code{segmenter} components.
\code{\link[=as.segmenter]{as.segmenter()}} is especially useful in pipelines to avoid having to use
the \code{$} or \code{[} notation for subsetting.

\code{\link[=as.segmenter]{as.segmenter()}} simply returns the segmenter of a \code{tidycpt} object.

\code{\link[=as.seg_cpt]{as.seg_cpt()}} takes a wild-caught \code{segmenter} object of arbitrary class
and converts it into a \link{seg_cpt} object.

\code{\link[=is_segmenter]{is_segmenter()}} checks to see if a segmenter object implements all of the
S3 methods necessary to be considered a segmenter.
}
\examples{
# Segment a time series using PELT
x <- segment(CET, method = "pelt")

# Return the segmenter component
x |>
  as.segmenter()
  
# Note the class of this object could be anything
x |>
  as.segmenter() |>
  class()
  
# Convert the segmenter into the standardized seg_cpt class
x |>
  as.segmenter() |>
  as.seg_cpt()

# Is the segmenter valid?
x |>
  as.segmenter() |>
  is_segmenter()
}
\seealso{
Other tidycpt-generics: 
\code{\link{as.model}()},
\code{\link{changepoints}()},
\code{\link{diagnose}()},
\code{\link{fitness}()},
\code{\link{model_name}()}

Other segmenter-functions: 
\code{\link{fitness}()},
\code{\link{model_args}()},
\code{\link{seg_params}()}
}
\concept{segmenter-functions}
\concept{tidycpt-generics}
