% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-tables.R
\name{compare_tables}
\alias{compare_tables}
\alias{print.compare_tbl}
\title{Compare Two Tables}
\usage{
compare_tables(x, y, key_cols = NULL)

\method{print}{compare_tbl}(x, ...)
}
\arguments{
\item{x}{First data.frame or tibble to compare.}

\item{y}{Second data.frame or tibble to compare.}

\item{key_cols}{Character vector of column names to use as keys for matching
rows. If \code{NULL} (default), automatically detects character, factor, and
integer columns as keys.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An S3 object of class \code{compare_tbl} containing:
\describe{
\item{name1, name2}{Names of the compared objects}
\item{common_columns}{Column names present in both tables}
\item{only_x}{Column names only in x}
\item{only_y}{Column names only in y}
\item{type_mismatches}{Data.frame of columns with different types, or NULL}
\item{nrow_x}{Number of rows in x}
\item{nrow_y}{Number of rows in y}
\item{key_summary}{Summary of key overlap, or NULL}
\item{numeric_summary}{Data.frame of numeric discrepancies, or NULL}
\item{numeric_method}{How numeric columns were compared}
\item{rows_matched}{Number of rows matched on keys}
}
}
\description{
Compares two data.frames or tibbles by examining column names, row counts,
key overlap, and numeric discrepancies. Useful for validating data processing
pipelines.
}
\examples{
x <- data.frame(id = 1:3, value = c(10.0, 20.0, 30.0))
y <- data.frame(id = 1:3, value = c(10.1, 20.0, 30.5))
compare_tables(x, y)

}
\seealso{
Other join validation: 
\code{\link{validate_join}()},
\code{\link{validate_primary_keys}()},
\code{\link{validate_var_relationship}()}
}
\concept{join validation}
