% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_label.R
\name{drop_label}
\alias{drop_label}
\title{Drop attributes/labels from variables or data frames}
\usage{
drop_label(x, ...)
}
\arguments{
\item{x}{A data frame or a vector/column.}

\item{...}{When \code{x} is a data frame, select variables using tidyselect
helpers (e.g., \code{contains()}, \code{starts_with()}) or unquoted names.
If empty, removes labels from ALL variables. Ignored when \code{x} is a vector.}
}
\value{
The modified data frame or vector with attributes removed.
}
\description{
Some functions don't work with labelled variables. As a solution,
this function can be used to drop labels (and all other attributes) from
one or more variables within a data frame, from all variables if none are
specified, or from a vector directly.
}
\examples{
\dontrun{
# Dataset-level: Remove labels from ALL variables
df |> drop_label()

# Dataset-level: Remove labels from specific variables
df |> drop_label(employment, starts_with("dem_"))

# Variable-level: Use inside mutate
df |> mutate(name_first = drop_label(name_first))

# Variable-level: Use with across()
df |> mutate(across(c(age, income), drop_label))
}

}
