% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_simulate.R
\name{ild_simulate}
\alias{ild_simulate}
\title{Simulate simple ILD for examples and tests}
\usage{
ild_simulate(n_id = 5L, n_obs_per = 10L, irregular = FALSE, seed = 42L)
}
\arguments{
\item{n_id}{Integer. Number of persons (default 5).}

\item{n_obs_per}{Integer. Observations per person (default 10).}

\item{irregular}{Logical. If `TRUE`, add random jitter to time (default `FALSE`).}

\item{seed}{Integer. Random seed for reproducibility (default 42).}
}
\value{
A data frame with columns `id`, `time` (POSIXct or numeric), and `y`.
}
\description{
Generates a small tibble with id, time, and one or more variables,
optionally with irregular spacing. Use [ild_prepare()] after to get
a proper ILD object.
}
\examples{
d <- ild_simulate(n_id = 3, n_obs_per = 5, seed = 1)
x <- ild_prepare(d, id = "id", time = "time")
}
