% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectation.R
\name{expect}
\alias{expect}
\title{The previous building block of all \code{expect_} functions}
\usage{
expect(
  ok,
  failure_message,
  info = NULL,
  srcref = NULL,
  trace = NULL,
  trace_env = caller_env()
)
}
\arguments{
\item{ok}{\code{TRUE} or \code{FALSE} indicating if the expectation was successful.}

\item{failure_message}{A character vector describing the failure. The
first element should describe the expected value, and the second (and
optionally subsequence) elements should describe what was actually seen.}

\item{info}{Character vector continuing additional information. Included
for backward compatibility only and new expectations should not use it.}

\item{srcref}{Location of the failure. Should only needed to be explicitly
supplied when you need to forward a srcref captured elsewhere.}

\item{trace}{An optional backtrace created by \code{\link[rlang:trace_back]{rlang::trace_back()}}.
When supplied, the expectation is displayed with the backtrace.
Expert use only.}

\item{trace_env}{If \code{trace} is not specified, this is used to generate an
informative traceback for failures. You should only need to set this if
you're calling \code{fail()} from a helper function; see
\code{vignette("custom-expectation")} for details.}
}
\value{
An expectation object from either \code{succeed()} or \code{fail()}.
with a \code{muffle_expectation} restart.
}
\description{
Previously, we recommended using \code{expect()} when writing your own
expectations. Now we instead recommend \code{\link[=pass]{pass()}} and \code{\link[=fail]{fail()}}. See
\code{vignette("custom-expectation")} for details.
}
\seealso{
\code{\link[=exp_signal]{exp_signal()}}
}
\keyword{internal}
