% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_test_functions.R
\name{run_covr}
\alias{run_covr}
\title{Run covr in a Subprocess with a Timeout}
\usage{
run_covr(path, timeout)
}
\arguments{
\item{path}{Character. Path to the package source directory for which
coverage should be computed.}

\item{timeout}{Numeric. Maximum time (in seconds) allowed for the coverage
computation. Defaults to \code{Inf}, meaning no timeout is applied unless
explicitly set.}
}
\value{
A coverage object returned by the underlying covr call, or \code{NULL} if
the subprocess execution fails or times out.
}
\description{
This internal helper runs coverage evaluation in a separate R subprocess
using `callr`. It allows coverage to be computed with a specified timeout,
ensuring that long‑running or hanging test processes do not block further
analysis.
}
\details{
The function launches a safe R session via \code{callr::r_safe()} and
executes the relevant covr routines within that isolated environment.
This is used internally by higher‑level STF/NSTF coverage functions to
ensure reproducible and controlled coverage execution.
}
\keyword{internal}
