% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_coverage.R
\name{get_package_coverage}
\alias{get_package_coverage}
\title{get package test coverage}
\usage{
get_package_coverage(path = NULL)
}
\arguments{
\item{path}{(optional) path of locally stored package source code}
}
\value{
An object of class \code{"coverage"} as produced by 
\code{test.assessr::run_covr_modes()}.  
This object is a structured list containing detailed test coverage
information, including:
\itemize{
  \item \strong{File-level coverage:} percentage of lines covered in each file.
  \item \strong{Line-by-line coverage:} number of executions for each line.
  \item \strong{Overall coverage:} aggregated coverage across the package.
  \item \strong{Metadata:} source file paths, expressions, and summary stats.
}

The resulting object can be printed, summarized, or passed to 
\code{test.assessr::generate_test_report()} to produce a human-readable test
coverage report.

Returns \code{NULL} if the package cannot be installed or if the specified
path does not exist.
}
\description{
simplified input to assess package for test coverage
}
\examples{
\donttest{
# Example STF package included in test.assessr
pkg_source_path <- system.file(
  "test-data",
  "test.package.0001_0.1.0.tar.gz",
  package = "test.assessr"
)

# Run get_package_coverage
get_package_coverage <- get_package_coverage(pkg_source_path)
}
}
