% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_short_path}
\alias{extract_short_path}
\title{Extract the Last Two Path Components from a File Path}
\usage{
extract_short_path(long_file_name)
}
\arguments{
\item{long_file_name}{Character string. A full file path using `/` or `\\`
as separators.}
}
\value{
A character scalar containing the last two components of the path joined
with a forward slash—for example `"R/add.R"`—or a single component if only
one exists. The returned value is always of class \code{character}.
}
\description{
This helper function takes any full file path and extracts only the last
two components, such as `"R/add.R"`. It supports both forward slashes (`/`)
and backslashes (`\\`) to accommodate Windows, macOS, and Linux paths.
}
\details{
Trailing separators are preserved where meaningful (e.g., `"R/"` when the
input ends with a slash). Empty path components are removed except when
required to detect a trailing separator.
}
\section{Output Meaning}{

This function is intended for display and logging purposes, where only the
tail portion of a full file path is meaningful. It does not check for file
existence; it simply processes the string supplied by the user.
}

\examples{
extract_short_path("pkg/R/add.R")
extract_short_path("C:\\\\\\\\projects\\\\\\\\mypkg\\\\\\\\R\\\\\\\\helper.R")

}
