% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_skip_stf.R
\name{create_coverage_skip_stf}
\alias{create_coverage_skip_stf}
\title{Run Coverage While Skipping Failing Tests}
\usage{
create_coverage_skip_stf(
  pkg_source_path,
  pkg,
  test_path = "tests/testthat",
  test_skip,
  test_map,
  cov_env
)
}
\arguments{
\item{pkg_source_path}{Character. Path to the root of the package source.}

\item{pkg}{Character. Name of the package being tested.}

\item{test_path}{Character. Path to the test directory.
Defaults to `'tests/testthat'`.}

\item{test_skip}{Data frame. Mapping of failing tests, typically containing
columns `file`, `line1`, and `line2`. Each row describes a span of lines
that should be commented out before running coverage.}

\item{test_map}{Data frame. Mapping of all tests within the package (used
for diagnostic messaging and consistency checks).}

\item{cov_env}{Environment that holds the temporary coverage workspace and
shared state for the run.}
}
\value{
A coverage object (a list) returned by `covr::environment_coverage()`,
filtered to remove problematic entries. If coverage fails, the function
returns `NULL`.

The returned structure typically contains:
\describe{
  \item{filename}{Name of the file being measured.}
  \item{functions}{Function-level coverage information.}
  \item{linecoverage}{Line-by-line execution counts.}
  \item{srcref}{Source references extracted for coverage.}
}
}
\description{
This function runs coverage analysis using `covr` while temporarily
commenting out known failing tests. It is intended for situations where
specific tests must be skipped (e.g., due to upstream bugs or known
failures) so that coverage can still be computed on remaining tests.
}
\details{
The function:
\itemize{
  \item sets up a temporary coverage environment,
  \item identifies lines to skip based on `test_skip`,
  \item comments out those test lines,
  \item runs `covr::environment_coverage()`, and
  \item restores the original test files on exit.
}


If `test_skip` is `NULL`, failing tests must be detected elsewhere before
calling this function. This function does not perform test detection; it
only applies the skip mappings supplied in `test_skip`.
}
\seealso{
\code{\link[testthat]{test_dir}},
  \code{\link[covr]{package_coverage}},
  \code{\link[covr]{environment_coverage}}

Other stf_utility: 
\code{\link{map_test}()},
\code{\link{map_tests_stf}()},
\code{\link{nest_test}()},
\code{\link{run_covr_skip_stf}()}
}
\concept{stf_utility}
\keyword{internal}
