% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_filter_manager.R
\docType{class}
\encoding{UTF-8}
\name{module_filter_manager}
\alias{module_filter_manager}
\alias{ui_filter_manager_panel}
\alias{srv_filter_manager_panel}
\alias{ui_filter_manager}
\alias{srv_filter_manager}
\alias{srv_module_filter_manager}
\alias{.slicesGlobal-class}
\alias{.slicesGlobal}
\title{Manage multiple \code{FilteredData} objects}
\usage{
ui_filter_manager_panel(id)

srv_filter_manager_panel(id, slices_global)

ui_filter_manager(id)

srv_filter_manager(id, slices_global)

srv_module_filter_manager(id, module_fd, slices_global)
}
\arguments{
\item{id}{(\code{character(1)})
\code{shiny} module instance id.}

\item{slices_global}{(\code{reactiveVal})
containing \code{teal_slices}.}

\item{module_fd}{(\code{FilteredData})
Object containing the data to be filtered in a single \code{teal} module.}
}
\value{
Module returns a \code{slices_global} (\code{reactiveVal}) containing a \code{teal_slices} object with mapping.
}
\description{
Oversee filter states across the entire application.
}

\section{Slices global}{

The key role in maintaining the module-specific filter states is played by the \code{.slicesGlobal}
object. It is a reference class that holds the following fields:
\itemize{
\item \code{all_slices} (\code{reactiveVal}) - reactive value containing all filters registered in an app.
\item \code{module_slices_api} (\code{reactiveValues}) - reactive field containing references to each modules'
\code{FilteredData} object methods. At this moment it is used only in \code{srv_filter_manager} to display
the filter states in a table combining informations from \code{all_slices} and from
\code{FilteredData$get_available_teal_slices()}.
}

During a session only new filters are added to \code{all_slices} unless \code{\link{module_snapshot_manager}} is
used to restore previous state. Filters from \code{all_slices} can be activated or deactivated in a
module which is linked (both ways) by \code{attr(, "mapping")} so that:
\itemize{
\item If module's filter is added or removed in its \code{FilteredData} object, this information is passed
to \code{SlicesGlobal} which updates \code{attr(, "mapping")} accordingly.
\item When mapping changes in a \code{SlicesGlobal}, filters are set or removed from module's
\code{FilteredData}.
}
}

\section{Filter manager}{

Filter-manager is split into two parts:
\enumerate{
\item \code{ui/srv_filter_manager_panel} - Called once for the whole app. This module observes changes in
the filters in \code{slices_global} and displays them in a table utilizing information from \code{mapping}:
}
\itemize{
\item (\code{TRUE}) - filter is active in the module
\item (\code{FALSE}) - filter is inactive in the module
\item (\code{NA}) - filter is not available in the module
}
\enumerate{
\item \code{ui/srv_module_filter_manager} - Called once for each \code{teal_module}. Handling filter states
for of single module and keeping module \code{FilteredData} consistent with \code{slices_global}, so that
local filters are always reflected in the \code{slices_global} and its mapping and vice versa.
}
}

\keyword{internal}
