% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_intersection_sw.R
\name{test_intersection_sw}
\alias{test_intersection_sw}
\title{Signed Wald intersection test}
\usage{
test_intersection_sw(
  par,
  vcov,
  noninf = NULL,
  weights = NULL,
  nsim.null = 10000,
  index = NULL
)
}
\arguments{
\item{par}{(numeric) parameter estimates or \code{estimate} object}

\item{vcov}{(matrix) asymptotic variance estimate}

\item{noninf}{(numeric) non-inferiority margins}

\item{weights}{(numeric) optional weights}

\item{nsim.null}{number of sample used in Monte-Carlo simulation}

\item{index}{subset of parameters to test}
}
\value{
list with Wald
}
\description{
Calculating test statistics and p-values for the signed Wald
intersection test given by \deqn{SW = \inf_{\theta \in \cap_{i=1}^n H_i}
  \{(\widehat{\theta}-\theta)^\top W\widehat{\Sigma}W
  (\widehat{\theta}-\theta)\} } with individual hypotheses for each
coordinate of \eqn{\theta} given by \eqn{H_i: \theta_j < \delta_j} for some
non-inferiority margin \eqn{\delta_j}, \eqn{j=1,\ldots,n}.
}
\examples{
S <- matrix(c(1, 0.5, 0.5, 2), 2, 2)
thetahat <- c(0.5, -0.2)
test_intersection_sw(thetahat, S, nsim.null = 1e5)
test_intersection_sw(thetahat, S, weights = NULL)

\dontrun{ # only on 'lava' >= 1.8.2
e <- estimate(coef = thetahat, vcov = S, labels = c("p1", "p2"))
lava::closed_testing(e, test_intersection_sw, noninf = c(-0.1, -0.1)) |>
  summary()
}
}
\author{
Klaus Kähler Holst, Christian Bressen Pipper
}
