% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{normalize_las}
\alias{normalize_las}
\title{Normalize `LAS` object representing segmented tree.}
\usage{
normalize_las(las, quantile = c(0.001))
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{quantile}{Z quantile at which grown level is specified since
ground points may not be identifiable with common algorithms if
ground points are removed during segmentation}
}
\value{
A `LAS` object with Z values normalized to ground level.
}
\description{
Function to normalize LAS object. Function calculates
ground level based on the parameter specified by `quantile`,
subtracts it from all `Z`.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
# view histogram of Z values ranging from  -18 to -7 m
hist(las$Z)
las = normalize_las(las)
# view histogram of Z values now ranging from  0 to 11 m
hist(las$Z)
}
