% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_word_counts.R
\name{obtain_word_counts}
\alias{obtain_word_counts}
\title{Obtain Word Counts}
\usage{
obtain_word_counts(data_annotated, data_stopwords, stopwords_to_append)
}
\arguments{
\item{data_annotated}{A data frame containing the annotated text data. The data must include columns like \code{document}, \code{submissionid}, \code{sentenceid}, and \code{lemma}.}

\item{data_stopwords}{A vector of stopwords that will be excluded from the word count.}

\item{stopwords_to_append}{A vector of additional stopwords to be appended to \code{data_stopwords} before counting words.}
}
\value{
A tibble containing the word counts for each unique combination of \code{mID} (document, submissionid, sentenceid) and \code{word}. The tibble has columns:
\itemize{
\item \code{mID}: A unique identifier combining \code{document}, \code{submissionid}, and \code{sentenceid}.
\item \code{word}: The word itself.
\item \code{n}: The frequency of the word.
}
}
\description{
This function calculates the word counts for each document in the annotated dataset, excluding stopwords.
It unites the annotated dataset, applies stopwords filtering, and counts the occurrences of each word.
}
\details{
This function works by first uniting the \code{document}, \code{submissionid}, and \code{sentenceid} columns into a new identifier \code{mID}. Then, it filters out stopwords from the word count, counts the frequency of words, and returns the result.
}
