% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pct1rm.R
\name{pct1rm_rts}
\alias{pct1rm_rts}
\alias{pct1rm_helms}
\alias{pct1rm_brzycki}
\title{Mapping from reps and rpe to pct_1rm.}
\usage{
pct1rm_rts(reps, rpe)

pct1rm_helms(reps, rpe)

pct1rm_brzycki(reps, rpe)
}
\arguments{
\item{reps}{A vector of repetitions performed in a set.}

\item{rpe}{A vector of ratings of perceived exertion.}
}
\value{
A numeric vector listing the percentage of one 1 rep max.
}
\description{
\code{pct1rm_rts()} uses the table provided by reactive training systems.  \code{pct1rm_helms()} uses the table provided in a paper by Helms and colleagues.  \code{pct1rm_brzycki()} uses the table provided by Brzycki in his book.
}
\details{
\code{reps} must be length 1 or the same length as \code{rpe}.  RPE must be length 1 or the same length as \code{reps}.
}
\examples{
pct1rm_rts(reps = 10, rpe = 8)
resulting_function <- create_map_rep_rpe_to_pct(pct_lookup_rts)
pct1rm_helms(reps = 5, rpe = 8)
resulting_function <- create_map_rep_rpe_to_pct(pct_lookup_rts)
pct1rm_helms(reps = 5, rpe = 8)
resulting_function <- create_map_rep_rpe_to_pct(pct_lookup_brzycki)
}
