% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.VLSTAR.R
\name{predict.VLSTAR}
\alias{predict.VLSTAR}
\alias{predict}
\alias{print.vlstarpred}
\title{VLSTAR Prediction}
\usage{
\method{predict}{VLSTAR}(
  object,
  ...,
  n.ahead = 1,
  conf.lev = 0.95,
  st.new = NULL,
  M = 5000,
  B = 1000,
  st.num = NULL,
  newdata = NULL,
  method = c("naive", "Monte Carlo", "bootstrap")
)
}
\arguments{
\item{object}{An object of class \sQuote{\code{VLSTAR}} obtained through \command{VLSTAR()}}

\item{\dots}{further arguments to be passed to and from other methods}

\item{n.ahead}{An integer specifying the number of ahead predictions}

\item{conf.lev}{Confidence level of the interval forecast}

\item{st.new}{Vector of new data for the transition variable}

\item{M}{An integer with the number of errors sampled for the \code{Monte Carlo} method}

\item{B}{An integer with the number of errors sampled for the \code{bootstrap} method}

\item{st.num}{An integer with the index of dependent variable if \code{st.new} is \code{NULL}
and the transition variable is a lag of one of the dependent variables}

\item{newdata}{\code{data.frame} or \code{matrix} of new data for the exogenous variables}

\item{method}{A character identifying which multi-step ahead method should be used among \code{naive}, \code{Monte Carlo} and \code{bootstrap}}
}
\value{
A \code{list} containing:
\item{forecasts}{\code{data.frame} of predictions for each dependent variable and the (1-\eqn{\alpha}) prediction intervals}
\item{y}{a matrix of values for y}
}
\description{
One-step or multi-step ahead forecasts, with interval forecast, of a VLSTAR object.
}
\references{
Granger C.W.J. and Terasvirta T. (1993), Modelling Non-Linear Economic Relationships. \emph{Oxford University Press}

Lundbergh S. and Terasvirta T. (2007), Forecasting with Smooth Transition Autoregressive Models. \emph{John Wiley and Sons}

Terasvirta T. and Yang Y. (2014), Specification, Estimation and Evaluation of Vector Smooth Transition Autoregressive Models with Applications. \emph{CREATES Research Paper 2014-8}
}
\seealso{
\code{\link{VLSTAR}} for log-likehood and nonlinear least squares estimation of the VLSTAR model.
}
\author{
Andrea Bucci and Eduardo Rossi
}
\keyword{VLSTAR}
