% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sshist.R
\name{sshist_2d}
\alias{sshist_2d}
\title{Optimal 2D Histogram Binning (Shimazaki-Shinomoto Method)}
\usage{
sshist_2d(x, y = NULL, n_min = 2, n_max = 200)
}
\arguments{
\item{x}{Numeric vector (coord X) or a 2-column matrix.}

\item{y}{Numeric vector (coord Y). Optional if x is a matrix.}

\item{n_min}{Integer. Minimum number of bins (default 2).}

\item{n_max}{Integer. Maximum number of bins (default 200).
Algorithm will reduce this automatically if data resolution restricts it.}
}
\value{
An object of class \code{"sshist_2d"} containing optimal parameters.
}
\description{
Computes the optimal number of bins for a 2-dimensional histogram.
Includes checks for data resolution and biased variance calculation.
}
\examples{
# 1. Basic usage with base graphics
set.seed(42)
x <- rnorm(500)
y <- rnorm(500)
res <- sshist_2d(x, y)
plot(res)

# 2. Usage with ggplot2
if (requireNamespace("ggplot2", quietly = TRUE)) {
  library(ggplot2)
  df <- data.frame(x = x, y = y)

  ggplot(df, aes(x = x, y = y)) +
    geom_bin2d(bins = c(res$opt_nx, res$opt_ny)) +
    scale_fill_viridis_c() +
    ggtitle(paste0("Optimal 2D Bins: ", res$opt_nx, "x", res$opt_ny)) +
    theme_minimal()
}
}
