% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spexvb.R
\name{spexvb}
\alias{spexvb}
\title{Parameter Expanded Variational Bayes for Well-Calibrated High-Dimensional Linear Regression with Spike-and-Slab Priors}
\usage{
spexvb(
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  tau_e = NULL,
  update_order = NULL,
  mu_alpha = 1,
  tau_alpha = 1000,
  tau_b = 400,
  standardize = TRUE,
  intercept = TRUE,
  max_iter = 1000,
  tol = 1e-05,
  seed = 12376
)
}
\arguments{
\item{X}{A numeric matrix. The design matrix (n observations × p predictors).}

\item{Y}{A numeric vector. The response vector of length n.}

\item{mu_0}{Optional numeric vector. Initial variational means for regression coefficients.}

\item{omega_0}{Optional numeric vector. Initial spike probabilities.}

\item{c_pi_0}{Optional numeric. Prior Beta(a, b) parameter a for the spike probability.}

\item{d_pi_0}{Optional numeric. Prior Beta(a, b) parameter b for the spike probability.}

\item{tau_e}{Optional numeric. Known or estimated error precision.}

\item{update_order}{Optional integer vector. The coordinate update order (0-indexed for C++).}

\item{mu_alpha}{Prior mean for alpha. Default is 1.}

\item{tau_alpha}{Prior precision for alpha. Default is 1000.}

\item{tau_b}{Slab prior precision. Default is 400.}

\item{standardize}{Logical. Center Y, and center and scale X. Default is TRUE.}

\item{intercept}{Logical. Whether to include an intercept. Default is TRUE. After the model is fit on the centered and scaled data, the final coefficients are "unscaled" to put them back on the original scale of your data. The intercept is then calculated separately using the means and the final coefficients.}

\item{max_iter}{Maximum number of iterations for the variational update. Default is 1000.}

\item{tol}{Convergence threshold for entropy and alpha change. Default is 1e-5.}

\item{seed}{Integer seed for cross-validation in glmnet. Default is 12376.}
}
\value{
A list with posterior summaries including estimated coefficients (\code{mu}),
inclusion probabilities (\code{omega}), intercept (if applicable), alpha path, convergence status, etc.
}
\description{
Fits a sparse linear regression model using variational inference with an alpha expansion step.
The model uses spike-and-slab priors.
}
\details{
This function acts as a wrapper for a C++ implementations of the SPEVXB algorithm.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
Y <- X[,1] * 2 + rnorm(n)
result <- spexvb(X = X, Y = Y)
}
}
