% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_performance.R
\name{print_performance}
\alias{print_performance}
\title{print_performance}
\usage{
print_performance(model)
}
\arguments{
\item{model}{Model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Prints model performance scores to the console.
}
\description{
Prints the performance slot of a model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}. For models fitted with \code{\link[=rf_repeat]{rf_repeat()}} it shows the median and the median absolute deviation of each performance measure.
}
\examples{

data(plants_rf)

print_performance(plants_rf)

}
\seealso{
\code{\link[=print_performance]{print_performance()}}, \code{\link[=get_performance]{get_performance()}}

Other model_info: 
\code{\link{get_evaluation}()},
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()}
}
\concept{model_info}
