% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation}
\alias{get_evaluation}
\title{Extract evaluation metrics from cross-validated model}
\usage{
get_evaluation(model)
}
\arguments{
\item{model}{Model object with class \code{rf_evaluate} from \code{\link[=rf_evaluate]{rf_evaluate()}}.}
}
\value{
Data frame with aggregated evaluation metrics containing:
\itemize{
\item \code{model}: Model type - "Full" (original model), "Training" (trained on training folds), or "Testing" (performance on testing folds, representing generalization ability).
\item \code{metric}: Metric name - "rmse", "nrmse", "r.squared", or "pseudo.r.squared".
\item \code{mean}, \code{sd}, \code{min}, \code{max}: Summary statistics across cross-validation repetitions.
}
}
\description{
Extracts aggregated performance metrics from a model evaluated with \code{\link[=rf_evaluate]{rf_evaluate()}}.
}
\details{
This function returns aggregated statistics across all cross-validation repetitions. The "Testing" model metrics indicate the model's ability to generalize to unseen spatial locations.
}
\examples{

if(interactive()){

data(plants_rf, plants_xy)

# Evaluate model with spatial cross-validation
m_evaluated <- rf_evaluate(
  model = plants_rf,
  xy = plants_xy,
  repetitions = 5,
  n.cores = 1
)

# Extract evaluation metrics
eval_metrics <- get_evaluation(m_evaluated)
eval_metrics

}

}
\seealso{
\code{\link[=rf_evaluate]{rf_evaluate()}}, \code{\link[=plot_evaluation]{plot_evaluation()}}, \code{\link[=print_evaluation]{print_evaluation()}}

Other model_info: 
\code{\link{get_importance}()},
\code{\link{get_importance_local}()},
\code{\link{get_moran}()},
\code{\link{get_performance}()},
\code{\link{get_predictions}()},
\code{\link{get_residuals}()},
\code{\link{get_response_curves}()},
\code{\link{get_spatial_predictors}()},
\code{\link{print.rf}()},
\code{\link{print_evaluation}()},
\code{\link{print_importance}()},
\code{\link{print_moran}()},
\code{\link{print_performance}()}
}
\concept{model_info}
