#' SF object defining ROI metaleurop
#'
#' @description Simple feature collection with 1 feature and 1 field.
#' Geodetic CRS:  WGS 84.
#'
#' @usage data(roi_metaleurop)
#'
#' @examples
#' data(roi_metaleurop)
#' @keywords datasets
"roi_metaleurop"


#' SF object defining very simplified OCS-GE soil cover metaleurop
#'
#' @description Simple feature collection with 9 features and 11 fields.
#' Projected CRS: RGF93 v1 / Lambert-93.
#'
#' @usage data(ocsge_metaleurop)
#'
#' @examples
#' data(ocsge_metaleurop)
#' @keywords datasets
"ocsge_metaleurop"


#' Nomenclature of OCS-GE soil cover
#'
#' @usage data(ref_ocsge)
#'
#' @examples
#' data(ref_ocsge)
#' @keywords datasets
"ref_ocsge"

#' DataBase of collected MicroMammals species
#'
#' @usage data(sf_micromammals)
#'
#' @examples
#' data(sf_micromammals)
#' @keywords datasets
"sf_micromammals"

#' Valued weight between OCSGE layer and species
#'
#' @usage data(ocsge_species_dict)
#'
#' @examples
#' data(ocsge_species_dict)
#' @keywords datasets
"ocsge_species_dict"

