# get_adi works

    Code
      get_adi(geography = "tract", state = "oh", county = "cuyahoga", year = 2010,
        dataset = "decennial", keep_indicators = TRUE, cache_tables = FALSE)
    Message
      
      2 call(s) to tidycensus beginning.
      Getting data from the 2006-2010 5-year ACS
      Getting data from the 2010 decennial Census
      Using Census Summary File 1
      
      Single imputation performed
    Output
      # A tibble: 447 x 135
         GEOID       NAME                                          ADI
         <chr>       <chr>                                       <dbl>
       1 39035101101 Census Tract 1011.01, Cuyahoga County, Ohio 130. 
       2 39035101102 Census Tract 1011.02, Cuyahoga County, Ohio  97.1
       3 39035101200 Census Tract 1012, Cuyahoga County, Ohio    131. 
       4 39035101300 Census Tract 1013, Cuyahoga County, Ohio    125. 
       5 39035101400 Census Tract 1014, Cuyahoga County, Ohio    112. 
       6 39035101501 Census Tract 1015.01, Cuyahoga County, Ohio 120. 
       7 39035101603 Census Tract 1016.03, Cuyahoga County, Ohio 123. 
       8 39035101700 Census Tract 1017, Cuyahoga County, Ohio    124. 
       9 39035101800 Census Tract 1018, Cuyahoga County, Ohio    127. 
      10 39035101901 Census Tract 1019.01, Cuyahoga County, Ohio 121. 
         Financial_Strength Economic_Hardship_and_Inequality Educational_Attainment
                      <dbl>                            <dbl>                  <dbl>
       1               81.2                             131.                   64.5
       2              104.                              101.                  112. 
       3               82.7                             130.                   54.3
       4               85.5                             127.                   76.6
       5               86.4                             102.                   61.7
       6               82.9                             119.                   85.1
       7               82.3                             120.                   66.5
       8               85.5                             125.                   79.2
       9               82.0                             126.                   66.0
      10               81.6                             124.                   96.7
         medianFamilyIncome medianMortgage medianRent medianHouseValue
                      <dbl>          <dbl>      <dbl>            <dbl>
       1              21375           1348        544            72900
       2              62586           1363        676           159100
       3              23250           1084        407            85200
       4              21957           1189        545           117600
       5              42500           1062        807            78200
       6              26766           1167        639            83400
       7              26271           1193        669            81500
       8              21354           1280        594            81300
       9              24949           1111        605            71800
      10              28688           1173        588           105400
         pctFamiliesInPoverty pctOwnerOccupiedHousing
                        <dbl>                   <dbl>
       1                0.379                   0.176
       2                0.138                   0.310
       3                0.410                   0.216
       4                0.504                   0.152
       5                0.120                   0.459
       6                0.344                   0.361
       7                0.374                   0.413
       8                0.461                   0.292
       9                0.410                   0.334
      10                0.454                   0.362
         ratioThoseMakingUnder10kToThoseMakingOver50k
                                                <dbl>
       1                                         5.80
       2                                         3.04
       3                                         5.67
       4                                         4.22
       5                                         2.85
       6                                         4.69
       7                                         4.70
       8                                         4.71
       9                                         5.65
      10                                         4.18
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.519
       2                                         0.198
       3                                         0.602
       4                                         0.598
       5                                         0.349
       6                                         0.475
       7                                         0.535
       8                                         0.574
       9                                         0.622
      10                                         0.501
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.744                      0.408
       2                                        0.525                      0.129
       3                                        0.650                      0.424
       4                                        0.692                      0.409
       5                                        0.616                      0.143
       6                                        0.664                      0.321
       7                                        0.664                      0.138
       8                                        0.718                      0.231
       9                                        0.648                      0.257
      10                                        0.681                      0.400
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                       0.116               0.235 
       2                       0.416               0.123 
       3                       0.289               0.189 
       4                       0.222               0.0919
       5                       0.175               0.119 
       6                       0.155               0.152 
       7                       0.117               0.256 
       8                       0.255               0.227 
       9                       0.197               0.215 
      10                       0.0645              0.186 
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.666                                 0.122 
       2                           0.898                                 0.0161
       3                           0.667                                 0.142 
       4                           0.683                                 0.0541
       5                           0.664                                 0.0825
       6                           0.720                                 0.0782
       7                           0.692                                 0.151 
       8                           0.689                                 0.0432
       9                           0.651                                 0.111 
      10                           0.720                                 0.0269
         pctHouseholdsWithOverOnePersonPerRoom P018001 B15002_001 B15002_003
                                         <dbl>   <dbl>      <dbl>      <dbl>
       1                               0.0175      850       1325         23
       2                               0.00705    2474       3604         28
       3                               0.0351     1379       1773          0
       4                               0.0311      841       1293          0
       5                               0.0512      813       1467          0
       6                               0           878       1662          0
       7                               0           895       1255          0
       8                               0.0323     1020       1412          0
       9                               0.0174     1002       1888         46
      10                               0           616        744          0
         B15002_004 B15002_005 B15002_006 B15002_011 B15002_012 B15002_013 B15002_014
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          7         71        234         24        125         40
       2          0          0         13        340         55        470        180
       3         47          0         10        259         14        132         22
       4          0          0         41        219         44         44         78
       5         23          0         20        330         77         85         14
       6          0         24         17        407         34         91         18
       7         34         79         18        191         35         76         23
       8          0          0          7        234         11        102         10
       9         11          0         76        305         78        116         35
      10          0          0          4        208         34         55         29
         B15002_015 B15002_016 B15002_017 B15002_018 B15002_020 B15002_021 B15002_022
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         19          0          0          0         18          0          7
       2        435        175         89          4          0          0          0
       3         68         69         20         24         44         51          0
       4        108          0          0          0          0          8          0
       5         29          0          0          0          0         37         30
       6         71          9          0          0         25          0         39
       7         26          0          4          0         11          0          0
       8         47         41          0          0         11          0          0
       9         39         30          0          0         15          0          8
      10          7          6          0          0          0          0         16
         B15002_023 B15002_028 B15002_029 B15002_030 B15002_031 B15002_032 B15002_033
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         36        247         18         44         83         29         19
       2         17        178         47        436        124        383        215
       3         99        205         33        164         35         97         41
       4         21        103         63        114         14         96          0
       5         11        202         71         76          0         16         52
       6         25        347         58         66          8         69          9
       7         47        256         36        144         58         11          0
       8         43        231         51        184          0         62          0
       9         53        305         70         49        101         86          9
      10          0        120         34          0          7         28          8
         B15002_034 B15002_035 B17010_001 B17010_002 B19001_002 B19001_011 B19001_012
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0        301        114        251         45         31
       2         92         14        762        105        256        315        318
       3          0          0        573        235        560          0        112
       4          0          0        272        137        133         19         45
       5         17          5        524         63         53         69        168
       6          9          0        553        190        214         41         71
       7          8          0        470        176        195         29         16
       8          0          0        560        258        229        114         52
       9          7          0        578        237        232          8         19
      10          0          0        379        172         77          0         56
         B19001_013 B19001_014 B19001_015 B19001_016 B19001_017 B19113_001 B23001_006
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0          0          0          0      21375         27
       2        289        145         79         31         53      62586         43
       3         29         39          0         13          0      23250         59
       4         65         66          0          0          0      21957          0
       5         39          0         31          0          0      42500         54
       6         10         39         19         17          0      26766         24
       7         60         72          0          0          0      26271         42
       8         41          0          0          0          0      21354         30
       9         33          0          0          0         22      24949          7
      10         21         32          6          0          3      28688          0
         B23001_008 B23001_013 B23001_015 B23001_020 B23001_022 B23001_027 B23001_029
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         12         82         32          0          0        145          0
       2         30         26          0        112         15        243         28
       3         30         30         12         33          0         38         16
       4          0         16          0         31          0          6          0
       5          8         20         20         27         17        156         16
       6         24          0          0          0          0         79         17
       7         20         27         12         58         46         28          0
       8          1         13          0         40         40         53         32
       9          0         36          0         42         19         81         16
      10          0         22         22          0          0          4          0
         B23001_034 B23001_036 B23001_041 B23001_043 B23001_048 B23001_050 B23001_055
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         73          0        124         27         43         18         47
       2        282         71        618         59        237         32         85
       3        141          0        118         20        113         50         20
       4        132         17        214         28         99          0         23
       5        103         52         82          5        153         22         86
       6        105          0        141         34        160          8          7
       7         13          0         49          0        172          0         38
       8         59         12        147         37         75         13         19
       9         70         11        177         56         83          0          0
      10         51          0         17          0        158         22         50
         B23001_057 B23001_062 B23001_064 B23001_069 B23001_071 B23001_074 B23001_076
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0         38          0          0          0          0          0
       2          6         57          0         49          0         43          0
       3          0          9          0         13          0         12          0
       4          0          0          0         10          0          0          0
       5          0          0          0         17          0          0          0
       6          0         21          0          0          0          9          0
       7          0          0          0         22          0          9          0
       8          9          9          0         18          0          0          0
       9          0          9          0         22         22         24          0
      10          0          0          0          0          0          0          0
         B23001_079 B23001_081 B23001_084 B23001_086 B23001_092 B23001_094 B23001_099
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0          0          0          0          0         49
       2          0          0         12          0         86         28         54
       3          0          0          0          0         54         26         46
       4          0          0          0          0          0          0         44
       5          0          0          0          0         13          0         19
       6          0          0          0          0         31          0         10
       7          0          0          0          0         18         12          0
       8          0          0          0          0         60         49         73
       9          1          0          0          0         51         32         28
      10          8          0          0          0         36          0         47
         B23001_101 B23001_106 B23001_108 B23001_113 B23001_115 B23001_120 B23001_122
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0          0         53         53         29         18
       2          0        103          0        240         17        139         29
       3          0         15          6         42          0         86          0
       4          0         59         33         33          0         20          0
       5          0         24          0        114          0         81          0
       6          0          0          0         83         45         75          0
       7          0          0          0          9          0         12          9
       8          0          0          0         39         10        100         34
       9         10         17          0         82          0        141          0
      10         47         87         33         39          0          0          0
         B23001_127 B23001_129 B23001_134 B23001_136 B23001_141 B23001_143 B23001_148
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        131         51         86         17         30          0         11
       2        314         30        290          0        135          0         99
       3         93         30         83          0         35          0         15
       4        108          0         17          0         19          0          0
       5        104          0         70          0         37          0         16
       6        200          9         91         22         39         10         18
       7        186         81         83         26          0          0         10
       8        158          0        164          0          9          9         20
       9        148         47         73         13         50         27         22
      10         53          0         92          0          3          0          0
         B23001_150 B23001_155 B23001_157 B23001_160 B23001_162 B23001_165 B23001_167
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0          0          4          0          0          0
       2         60         13          0         16          0          0          0
       3          0          0          0         11         11          0          0
       4          0          8          0         10          0          0          0
       5          0          0          0          0          0          0          0
       6          0          0          0         17          0          0          0
       7          0         18          0          9          0          3          0
       8          9         17          0         19          0          0          0
       9          0          0          0          4          0          0          0
      10          0          0          0          0          0          0          0
         B23001_170 B23001_172 B25014_001 B25014_005 B25014_006 B25014_007 B25014_011
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0       1026          0          0          0          0
       2          0          0       2694          0          7          0          0
       3          0          0       1397          8          0          0         41
       4          0          0        868          0          0          0          0
       5          0          0        761          0         39          0          0
       6          0          0        953          0          0          0          0
       7          0          0        687          0          0          0          0
       8          0          0        961          0          0         12          0
       9          9          0       1033          0          0          0         18
      10          0          0        513          0          0          0          0
         B25014_012 B25014_013 B25044_001 B25044_003 B25044_010 B25064_001 B25077_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         18          0       1026         21        398        544      72900
       2         12          0       2694         54        294        676     159100
       3          0          0       1397         64        529        407      85200
       4          0         27        868          3        352        545     117600
       5          0          0        761         78         31        807      78200
       6          0          0        953         34        272        639      83400
       7          0          0        687         20         75        669      81500
       8          0         19        961         15        207        594      81300
       9          0          0       1033         29        236        605      71800
      10          0          0        513          4        201        588     105400
         B25088_002 C17002_001 C17002_002 C17002_003 C17002_004 C17002_005 C24010_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1348       1725        299        393        187         16        744
       2       1363       4430        158        453        109        158       2891
       3       1084       2818        272       1029        251        144        865
       4       1189       1536        183        485        147        103        771
       5       1062       2161        173        194        285        102       1036
       6       1167       2257        273        524        118        156        941
       7       1193       1983        397        528        103         33        600
       8       1280       2418        658        396        233        102        867
       9       1111       2653        661        603        281        106        924
      10       1173       1283        214        392         25         12        543
         C24010_003 C24010_039 H003002 H014002 P020002 P020008
              <dbl>      <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1         57         29     850     150     172     128
       2        696        506    2474     768     314     165
       3        148        102    1379     298     263     171
       4         83         88     841     128     143      99
       5         83         98     813     373     318     196
       6         52         94     878     317     321     213
       7         54         16     895     370     354     235
       8         46        175    1020     298     408     293
       9         84         98    1002     335     330     214
      10         22         13     616     223     251     171
      # i 437 more rows

---

    Code
      set2_adi_results
    Output
      # A tibble: 574 x 6
         GEOID        NAME                                                        ADI
         <chr>        <chr>                                                     <dbl>
       1 100010401001 Block Group 1, Census Tract 401, Kent County, Delaware    102. 
       2 100010401002 Block Group 2, Census Tract 401, Kent County, Delaware     98.3
       3 100010401003 Block Group 3, Census Tract 401, Kent County, Delaware    119. 
       4 100010402011 Block Group 1, Census Tract 402.01, Kent County, Delaware 100. 
       5 100010402012 Block Group 2, Census Tract 402.01, Kent County, Delaware 106. 
       6 100010402021 Block Group 1, Census Tract 402.02, Kent County, Delaware  92.4
       7 100010402022 Block Group 2, Census Tract 402.02, Kent County, Delaware  88.7
       8 100010402031 Block Group 1, Census Tract 402.03, Kent County, Delaware 108. 
       9 100010402032 Block Group 2, Census Tract 402.03, Kent County, Delaware  83.2
      10 100010405011 Block Group 1, Census Tract 405.01, Kent County, Delaware 105. 
         Financial_Strength Economic_Hardship_and_Inequality Educational_Attainment
                      <dbl>                            <dbl>                  <dbl>
       1               97.4                             98.5                   88.2
       2               93.2                             91.5                  100. 
       3               80.4                            104.                    61.2
       4               92.7                             95.7                  102. 
       5               89.5                            104.                   104. 
       6              106.                              90.7                   98.7
       7              101.                              81.6                  101. 
       8               88.3                            105.                   100. 
       9              109.                              77.9                  101. 
      10               91.6                            103.                   103. 
      # i 564 more rows

---

    Code
      get_adi(geography = "zcta", zcta = c("99", "44147"), state = c("AK", "OH"),
      year = 2011, dataset = "acs5", keep_indicators = TRUE, cache_tables = FALSE)
    Message
      
      1 call(s) to tidycensus beginning.
      Getting data from the 2007-2011 5-year ACS
      
      Single imputation performed
    Output
      # A tibble: 239 x 85
         GEOID   NAME          ADI Financial_Strength Economic_Hardship_and_Inequality
         <chr>   <chr>       <dbl>              <dbl>                            <dbl>
       1 0299501 ZCTA5 99501  84.7               120.                             90.2
       2 0299502 ZCTA5 99502  72.2               133.                             77.1
       3 0299503 ZCTA5 99503  88.9               113.                             92.3
       4 0299504 ZCTA5 99504  78.9               125.                             82.6
       5 0299505 ZCTA5 99505  78.6               120.                             84.8
       6 0299506 ZCTA5 99506  70.1               134.                             77.4
       7 0299507 ZCTA5 99507  72.5               133.                             75.3
       8 0299508 ZCTA5 99508  85.8               117.                             89.4
       9 0299510 ZCTA5 99510  NA                  NA                              NA  
      10 0299513 ZCTA5 99513  NA                  NA                              NA  
         Educational_Attainment medianFamilyIncome medianMortgage medianRent
                          <dbl>              <dbl>          <dbl>      <dbl>
       1                   112.              65739           1784        880
       2                   119.              89159           2031       1093
       3                   108.              58277           1753        899
       4                   113.              79755           1848       1086
       5                   122.              51646           1811       1714
       6                   124.              59400           2058       1824
       7                   115.              89337           1927       1181
       8                   110.              64459           1754        964
       9                    NA                  NA             NA         NA
      10                    NA                  NA             NA         NA
         medianHouseValue pctFamiliesInPoverty pctOwnerOccupiedHousing
                    <dbl>                <dbl>                   <dbl>
       1           246700               0.105                  0.309  
       2           278800               0.0509                 0.693  
       3           213400               0.111                  0.325  
       4           242500               0.0726                 0.626  
       5           164400               0.0714                 0.00656
       6           201300               0.0586                 0.00510
       7           264100               0.0338                 0.722  
       8           224100               0.112                  0.480  
       9               NA              NA                     NA      
      10               NA              NA                     NA      
         ratioThoseMakingUnder10kToThoseMakingOver50k
                                                <dbl>
       1                                        2.17 
       2                                        0.949
       3                                        2.68 
       4                                        1.54 
       5                                        2.33 
       6                                        1.25 
       7                                        0.975
       8                                        1.82 
       9                                       NA    
      10                                       NA    
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                        0.265 
       2                                        0.134 
       3                                        0.264 
       4                                        0.186 
       5                                        0.209 
       6                                        0.142 
       7                                        0.0974
       8                                        0.263 
       9                                        0     
      10                                       NA     
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.455                     0.149 
       2                                        0.388                     0.0362
       3                                        0.511                     0.185 
       4                                        0.414                     0.0657
       5                                        0.203                     0.0109
       6                                        0.134                     0.0136
       7                                        0.333                     0.0414
       8                                        0.490                     0.117 
       9                                       NA                        NA     
      10                                       NA                        NA     
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.418              0.106 
       2                        0.348              0.0626
       3                        0.306              0.0728
       4                        0.335              0.0832
       5                        0.184              0.139 
       6                        0.372              0.120 
       7                        0.391              0.0687
       8                        0.312              0.113 
       9                        0.498              0     
      10                       NA                 NA     
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.886                                 0.0570
       2                           0.942                                 0.0156
       3                           0.851                                 0.0608
       4                           0.908                                 0.0446
       5                           0.947                                 0     
       6                           0.985                                 0     
       7                           0.915                                 0.0325
       8                           0.875                                 0.0418
       9                           1                                     0     
      10                          NA                                    NA     
         pctHouseholdsWithOverOnePersonPerRoom B11005_001 B11005_002 B11005_005
                                         <dbl>      <dbl>      <dbl>      <dbl>
       1                                0.0297       7540       1627        740
       2                                0.0350       8740       3741       1450
       3                                0.0655       5756       1352        691
       4                                0.0527      14713       5595       2314
       5                                0.0109       1371       1210        246
       6                                0.0136       1766       1403        188
       7                                0.0447      13922       5337       1775
       8                                0.0875      12796       4666       2285
       9                               NA               0          0          0
      10                               NA               0          0          0
         B15002_001 B15002_003 B15002_004 B15002_005 B15002_006 B15002_011 B15002_012
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      11712         23         63         51        158       1434        426
       2      15393         30          0         21         52       2021        616
       3       9077         58         84         88         55       1460        295
       4      25178        161         38         93        154       3710       1050
       5       2393          0          0          0          0        191        145
       6       2570          0          0          0          0        201        188
       7      24323         82         32        151        141       2692        826
       8      20797        154         41         23         86       2764        858
       9        339          0          0          0          0        158         30
      10          0          0          0          0          0          0          0
         B15002_013 B15002_014 B15002_015 B15002_016 B15002_017 B15002_018 B15002_020
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1375        480       1079        506        224         98         53
       2       1606        634       1515        505        153         27         33
       3       1053        382        661        157         50         30         19
       4       2540        946       1934        611        238        117        277
       5        526         99        257         28         36          0          0
       6        329        294        155        110          0          0          0
       7       2392        955       2638        927        460        252         73
       8       2152        791       1240        597        329        221        239
       9         60          0         30          0          0          0          0
      10          0          0          0          0          0          0          0
         B15002_021 B15002_022 B15002_023 B15002_028 B15002_029 B15002_030 B15002_031
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1         64        145        110       1080        419        694        398
       2          0         61         43       1560        646       1993        877
       3         58         81        109       1153        316        827        166
       4         35        253        112       3478       1163       2820       1126
       5          0          0          0        298        172        302         92
       6          0          0          0        231        156        397        177
       7          7        213         92       2497       1119       2348       1039
       8        200         82         45       2938        808       2192        710
       9          0          0          0          0          0          0          0
      10          0          0          0          0          0          0          0
         B15002_032 B15002_033 B15002_034 B15002_035 B17010_001 B17010_002 B19001_002
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1123        675        221        141       3098        325        328
       2       1630        424        232         55       6379        325        159
       3        787        288         77         22       2757        306        373
       4       2108        822        112         92       9911        720        460
       5        100         19          0          0       1344         96         78
       6        211         83          0          0       1724        101         36
       7       2829       1023        139        116       9676        327        279
       8       1562        881         83         77       7870        885        443
       9         61          0          0          0          0          0          0
      10          0          0          0          0          0          0          0
         B19001_011 B19001_012 B19001_013 B19001_014 B19001_015 B19001_016 B19001_017
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        629        780        891        429        438        300        292
       2        509        974       1259       1200        991        687        533
       3        357        660        705        333        317         92         86
       4       1107       1716       2729       1902        870       1012        509
       5        271        229        137         59          0         19         44
       6        179        308        264        147        104         33          0
       7        836       1620       2566       1924       1395       1250        935
       8       1264       1373       2038        718        474        767        570
       9          0          0          0          0          0          0          0
      10          0          0          0          0          0          0          0
         B19113_001 B23025_003 B23025_005 B25003_001 B25003_002 B25014_001 B25014_005
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      65739       8705        919       7540       2330       7540         17
       2      89159      13748        861       8740       6061       8740         32
       3      58277       8401        612       5756       1872       5756         52
       4      79755      20842       1735      14713       9216      14713        216
       5      51646        765        106       1371          9       1371          0
       6      59400       1308        157       1766          9       1766          0
       7      89337      23077       1585      13922      10058      13922        315
       8      64459      18892       2141      12796       6148      12796        216
       9         NA        309          0          0          0          0          0
      10         NA          0          0          0          0          0          0
         B25014_006 B25014_007 B25014_011 B25014_012 B25014_013 B25044_001 B25044_003
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1          0          0        170         37          0       7540         86
       2         37          0        134         77         26       8740         66
       3         10          0        191        110         14       5756        239
       4         47         29        384        100          0      14713        311
       5          0          0         15          0          0       1371          0
       6          0          0         24          0          0       1766          0
       7         34          0        230         44          0      13922        161
       8         92         48        535        195         34      12796        324
       9          0          0          0          0          0          0          0
      10          0          0          0          0          0          0          0
         B25044_010 B25064_001 B25077_001 B25088_002 C17002_001 C17002_002 C17002_003
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1037        880     246700       1784      15362       1144       1152
       2        250       1093     278800       2031      23900        664        988
       3        826        899     213400       1753      13244       1167        705
       4        655       1086     242500       1848      39207       1985       2284
       5         15       1714         NA         NA       5199        176         96
       6         24       1824         NA         NA       6228         67        277
       7        415       1181     264100       1927      38670        835       1182
       8       1178        964     224100       1754      34938       1949       3419
       9          0         NA         NA         NA        339          0          0
      10          0         NA         NA         NA          0          0          0
         C17002_004 C17002_005 C24010_001 C24010_003 C24010_039
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1041        732       7786       1594       1658
       2        549        991      12887       2073       2410
       3        631        988       7789       1125       1257
       4       1462       1553      19107       2836       3569
       5        397        416        659         19        102
       6        114        427       1151         91        337
       7        934        817      21492       4342       4068
       8       2432       1405      16751       2263       2960
       9          0          0        309        154          0
      10          0          0          0          0          0
      # i 229 more rows

---

    Code
      get_adi(geography = "state", year = 2010, dataset = "acs1", keep_indicators = TRUE,
        cache_tables = FALSE)
    Message
      
      1 call(s) to tidycensus beginning.
      Getting data from the 2010 1-year ACS
      The 1-year ACS provides data for geographies with populations of 65,000 and greater.
    Output
      # A tibble: 52 x 131
         GEOID NAME                   ADI Financial_Strength
         <chr> <chr>                <dbl>              <dbl>
       1 01    Alabama              121.                81.6
       2 02    Alaska                77.4              116. 
       3 04    Arizona              107.                97.2
       4 05    Arkansas             121.                76.0
       5 06    California            92.5              130. 
       6 08    Colorado              88.1              111. 
       7 09    Connecticut           76.7              129. 
       8 10    Delaware              87.9              112. 
       9 11    District of Columbia  80.0              158. 
      10 12    Florida              108.                97.7
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                            116.                    90.5              50429
       2                             83.6                  105.               76962
       3                            108.                    88.5              55353
       4                            112.                    89.1              47049
       5                            102.                    49.4              65481
       6                             90.8                  110.               67800
       7                             85.9                  109.               81246
       8                             88.8                  109.               68746
       9                            137.                   103.               77514
      10                            110.                    96.2              53093
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1130        667           123900               0.147 
       2           1772        981           241400               0.0719
       3           1442        844           168800               0.125 
       4            987        638           106300               0.141 
       5           2242       1163           370900               0.118 
       6           1590        863           236600               0.0941
       7           2068        992           288800               0.0715
       8           1569        952           243600               0.0808
       9           2297       1198           426900               0.141 
      10           1505        947           164200               0.120 
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.701                                         3.27
       2                   0.639                                         1.91
       3                   0.652                                         2.83
       4                   0.674                                         3.25
       5                   0.556                                         2.37
       6                   0.659                                         2.54
       7                   0.680                                         2.27
       8                   0.730                                         2.38
       9                   0.425                                         2.89
      10                   0.681                                         2.93
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.304
       2                                         0.184
       3                                         0.292
       4                                         0.313
       5                                         0.263
       6                                         0.221
       7                                         0.164
       8                                         0.191
       9                                         0.263
      10                                         0.272
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.391                     0.0659
       2                                        0.328                     0.104 
       3                                        0.368                     0.0686
       4                                        0.379                     0.0665
       5                                        0.325                     0.0781
       6                                        0.315                     0.0582
       7                                        0.331                     0.0906
       8                                        0.369                     0.0662
       9                                        0.537                     0.350 
      10                                        0.380                     0.0695
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.319              0.118 
       2                        0.351              0.0964
       3                        0.356              0.118 
       4                        0.309              0.0959
       5                        0.365              0.128 
       6                        0.397              0.0986
       7                        0.406              0.105 
       8                        0.377              0.0929
       9                        0.592              0.124 
      10                        0.335              0.133 
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.821                                 0.0619
       2                           0.910                                 0.0282
       3                           0.856                                 0.0631
       4                           0.829                                 0.0633
       5                           0.807                                 0.105 
       6                           0.897                                 0.0426
       7                           0.886                                 0.0460
       8                           0.877                                 0.0384
       9                           0.874                                 0.0472
      10                           0.855                                 0.0574
         pctHouseholdsWithOverOnePersonPerRoom B11005_001 B11005_002 B11005_005
                                         <dbl>      <dbl>      <dbl>      <dbl>
       1                                0.0185    1815152     590757     230862
       2                                0.0616     254610      96745      31772
       3                                0.0441    2334050     767324     282328
       4                                0.0260    1114902     365384     138588
       5                                0.0865   12406475    4606298    1497347
       6                                0.0271    1960585     636632     200508
       7                                0.0198    1358809     443077     146725
       8                                0.0221     328765     107912      39849
       9                                0.0280     252388      48753      26203
      10                                0.0265    7035068    2028915     770368
         B15003_001 B15003_002 B15003_003 B15003_004 B15003_005 B15003_006 B15003_007
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    3161521      40249        573        991       1396       3878       7237
       2     450577       2517         85        125        346        289        845
       3    4146758      46086        458        326       3557       8217      15958
       4    1919422      23942        128        147       1435       2512       5729
       5   24097200     573519       3313       8932      38140      94368     185415
       6    3328045      24450        163        354       1423       4397       8644
       7    2434383      20220         64        206       1015       3860       5227
       8     600779       5324         24         20        399        623       1028
       9     416824       5056          0          0        623        854        864
      10   13077179     174312       2897       2515       9534      20661      41458
         B15003_008 B15003_009 B15003_010 B15003_011 B15003_012 B15003_017 B15003_018
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       6039      10277      36860      30666      57400     817024     171181
       2        492       1265       2141        956       3647      92880      21175
       3      12464      14475      70578      20388      68954     872239     167958
       4       5106       5598      19432      16062      41413     553179     110897
       5     130510     160883     852521     140356     346994    4496875     515538
       6       6229       7650      37045      13623      37928     629426     129900
       7       7170       7563      20565      12700      33324     609078      78540
       8       1448       1446       4784        850       7147     174852      21307
       9       1275       1888       3234       2516       3358      71709      12860
      10      33092      52050     174762      72143     167587    3373011     543573
         B15003_019 B15003_020 B15003_021 B15003_022 B15003_023 B15003_024 B15003_025
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     184787     505576     225382     439863     182474      42102      28256
       2      33437      99780      37106      83346      30697       7333       4447
       3     319403     780822     336950     691889     269415      66393      46338
       4     131402     300791     121711     252888      86916      22130      12084
       5    1396739    3955068    1831667    4610875    1750623     543242     346531
       6     221119     532205     260733     779055     312761      69802      49612
       7     136644     294767     173047     491990     265228      68795      39286
       8      37337      82708      43386      99400      45974      12072       9622
       9      12360      45342      13337      96573      63707      33654      14890
      10     863171    1905622    1121500    2171876     810726     254682     133967
         B17010_001 B17010_002 B19001_002 B19001_011 B19001_012 B19001_013 B19001_014
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    1227884     180849     196253     141837     166139     177709     108049
       2     170859      12277      10654      20540      28076      33925      27201
       3    1548428     194239     186322     200211     238255     263927     164407
       4     761361     107243     109620      84402     106704     104649      57711
       5    8507856    1003305     741864     929799    1238774    1530962    1104395
       6    1258885     118446     133792     154810     206827     248333     167979
       7     890770      63695      79205     101448     129504     180261     125413
       8     221233      17881      19765      29257      35215      43486      29036
       9     101519      14285      26272      17862      21820      29131      19446
      10    4556930     548767     587347     594332     690596     750571     446574
         B19001_015 B19001_016 B19001_017 B19113_001 B23001_006 B23001_008 B23001_013
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      55859      54325      38814      50429      50878      18661      52746
       2      18645      16204      12870      76962       8774       2999       7856
       3      91640      76200      69847      55353      70209      22713      63432
       4      29498      24066      19554      47049      34217      11861      31394
       5     665489     752779     743938      65481     355879     140240     394820
       6      98362      93692      83674      67800      61189      18877      55998
       7      86772      91520     103713      81246      40236      11820      33602
       8      18109      16198      11775      68746       8177       1923       9351
       9      13603      17910      26102      77514       2843       1092       5619
      10     231442     215741     219419      53093     161737      61066     183082
         B23001_015 B23001_020 B23001_022 B23001_027 B23001_029 B23001_034 B23001_036
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      12403      73350      13560     126860      17978     119642      13170
       2       1569      10646       1643      22612       2675      20495       2091
       3      16496     106355      16972     182164      23990     179941      17964
       4       7051      42632       7021      78719       8112      79275       6444
       5      93042     636643     117141    1184021     172464    1154972     133824
       6      10543      85692      14770     165631      20482     165820      17331
       7       7228      56030       9684      94031      12824      91911       8116
       8       1340      13927       2952      23440       3606      21527       1679
       9       3446      11902       2121      26975       3142      24027       2327
      10      45815     267565      53981     483174      74921     479491      68737
         B23001_041 B23001_043 B23001_048 B23001_050 B23001_055 B23001_057 B23001_062
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     254289      24905     266247      23856     107310       7234      35896
       2      41836       2325      48550       3966      22864       2928       5439
       3     354556      37257     347381      37715     137559      13233      48991
       4     154843      11414     158075      10507      63337       3961      19655
       5    2320306     238644    2234261     239828     824099      88413     271339
       6     319338      20852     327396      29277     129751      11891      45849
       7     214666      18004     248465      21318      97079       9152      29723
       8      48416       3139      55428       4620      22684       1669       6916
       9      36806       3074      31428       4469      10614       1315       4201
      10    1051405     119336    1127767     131864     435536      54134     136867
         B23001_064 B23001_069 B23001_071 B23001_074 B23001_076 B23001_079 B23001_081
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       3085      36595       1844      32085       2356      13238        838
       2        305       6616        725       4649        283       1602        101
       3       3939      49754       5473      37372       4395      16739       1612
       4       1419      20396       1427      19824       1618       7648        178
       5      32960     294975      31943     238804      25283      96786       9694
       6       4944      42139       3406      35418       3002      13376       1373
       7       1771      38761       4036      33020       3766      12135       1528
       8        387       5999        248       6178        313       3049        394
       9        401       4669        508       4438        239       1655        183
      10      18407     172836      20389     156564      18776      64866       6583
         B23001_084 B23001_086 B23001_092 B23001_094 B23001_099 B23001_101 B23001_106
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       7555        560      50254      15733      52426      11169      64816
       2       1109        108       9172       2485       7164       1461      11450
       3      13103       1215      67493      20871      59845      10124      89711
       4       5786        457      32913       9045      31198       5206      40416
       5      69111       6327     335731     113131     350270      67860     547110
       6       7572        437      57180      14400      44527       5913      83616
       7      10558       1009      40561       8679      34941       5855      51151
       8       1365        127      10082       2753       8766       1146      14211
       9       1935          0       3961       1589       6415       1977      14949
      10      52599       5295     173079      55799     178853      32221     259404
         B23001_108 B23001_113 B23001_115 B23001_120 B23001_122 B23001_127 B23001_129
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      10862     118422      17490     109320      13700     235269      22700
       2       1714      18161       1875      16784       1622      32231       1818
       3      12515     154340      17933     146744      14208     301695      27726
       4       7949      71273       7414      65476       5206     139970      11159
       5      87815    1000047     127792     942400     110866    1891523     203294
       6       8088     140849      12739     135064      10853     268570      20114
       7       5662      86812       8521      84580       9047     197583      19734
       8       1718      22801       2329      22911       1844      47101       2717
       9       1455      31686       3497      25652       2479      34776       4592
      10      41148     440383      59258     432815      51776     965397     106222
         B23001_134 B23001_136 B23001_141 B23001_143 B23001_148 B23001_150 B23001_155
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     242774      22335      94097       6465      30949       1025      30567
       2      44759       2225      15366        759       4327        251       5785
       3     315593      28376     127790      10377      41952       3258      43674
       4     147735       9185      61699       1772      19836        791      21740
       5    1955901     197914     741389      67848     233416      22470     253724
       6     289551      18940     121510       9402      35832       3300      37608
       7     240313      19470      92991       7599      29868       1868      36052
       8      53016       3646      22629       1902       7078        438       7077
       9      27244       2398      13010        971       4707        360       5038
      10    1064757     109534     425493      43206     130065      10858     151823
         B23001_157 B23001_160 B23001_162 B23001_165 B23001_167 B23001_170 B23001_172
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1292      23253       1537       9703        408       5667        217
       2         18       3066         62       1450          0        940         12
       3       3377      34982       1857      12557       1363       7636       1052
       4       1260      17424       1013       7053        428       4900        208
       5      24858     188062      18364      66317       6603      43609       3725
       6       2814      30182       2675       9633        714       4933        413
       7       2688      28360       2694      10624       1003       5906        437
       8        296       6554        567       2249        300       2274         33
       9        390       4410        292       1449          0       1086         51
      10      17467     127335      12439      49509       5347      31183       4061
         B25003_001 B25003_002 B25014_001 B25014_005 B25014_006 B25014_007 B25014_011
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    1815152    1272846    1815152      10650       2961       1572      12434
       2     254610     162785     254610       5981       2370        744       3905
       3    2334050    1522938    2334050      30191       6764       3707      42698
       4    1114902     751568    1114902       7387       2607        681      10703
       5   12406475    6903175   12406475     224028      55588      19306     462034
       6    1960585    1292792    1960585      14025       2849        548      25399
       7    1358809     923617    1358809       5205       1123        686      13627
       8     328765     239884     328765       2794        359         51       3144
       9     252388     107193     252388        830        249        185       3385
      10    7035068    4794130    7035068      59403      11621       3486      82613
         B25014_012 B25014_013 B25044_001 B25044_003 B25044_010 B25064_001 B25077_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       3885       2158    1815152      39869      79742        667     123900
       2       1794        901     254610       9735      16753        981     241400
       3      14021       5602    2334050      41966     118200        844     168800
       4       5330       2263    1114902      20492      53697        638     106300
       5     213563      98087   12406475     187617     781483       1163     370900
       6       7928       2310    1960585      26533      87492        863     236600
       7       4765       1457    1358809      24559      98565        992     288800
       8        706        211     328765       7163      14616        952     243600
       9       1857        565     252388      14984      73406       1198     426900
      10      23043       6326    7035068     166145     322989        947     164200
         B25088_002 C17002_001 C17002_002 C17002_003 C17002_004 C17002_005 C24010_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1130    4666970     380317     507973     269227     263338    1978825
       2       1772     696822      28642      40637      28844      29751     337683
       3       1442    6272686     518499     575750     382501     351807    2655557
       4        987    2839798     221777     313121     173406     180403    1245328
       5       2242   36593372    2501263    3281780    1946590    1889854   16243172
       6       1590    4934178     297920     361866     220458     208283    2446674
       7       2068    3466977     164365     185780     105683     112480    1736446
       8       1569     874321      46917      56510      24643      38774     411120
       9       2297     570953      60988      48435      18777      22188     299127
      10       1505   18436788    1356324    1691019     983490     978004    7974945
         C24010_003 C24010_039
              <dbl>      <dbl>
       1     291080     339466
       2      53463      64974
       3     468574     476081
       4     168601     215718
       5    2972016    2953448
       6     487026     483223
       7     339322     366079
       8      68481      86478
       9      84967      92098
      10    1259933    1409038
      # i 42 more rows

---

    Code
      get_adi(geography = "county", geoid = c("39035136101", "35"), year = 2010,
      dataset = "acs5", keep_indicators = TRUE, cache_tables = FALSE)
    Condition
      Warning:
      One or more geoids are more granular than geography = "county"
      The county in which these elements dwell will be used.
    Message
      
      1 call(s) to tidycensus beginning.
      Getting data from the 2006-2010 5-year ACS
    Output
      # A tibble: 34 x 135
         GEOID NAME                            ADI Financial_Strength
         <chr> <chr>                         <dbl>              <dbl>
       1 39035 Cuyahoga County, Ohio          89.7              117. 
       2 35001 Bernalillo County, New Mexico  82.1              122. 
       3 35003 Catron County, New Mexico      98.3               87.4
       4 35005 Chaves County, New Mexico     111.                89.6
       5 35006 Cibola County, New Mexico     123.                84.2
       6 35007 Colfax County, New Mexico      96.9               94.3
       7 35009 Curry County, New Mexico      105.                92.2
       8 35011 De Baca County, New Mexico    107.                84.0
       9 35013 Do?a Ana County, New Mexico   109.               103. 
      10 35015 Eddy County, New Mexico        93.5               98.2
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                            112.                   122.               58064
       2                             92.9                  113.               59809
       3                             87.1                  121.               40906
       4                            103.                    80.5              43464
       5                            135.                    88.7              41187
       6                             96.9                  119.               48450
       7                            105.                   103.               48933
       8                             92.6                  100.0              36618
       9                            112.                    75.2              43184
      10                             81.9                   97.9              56646
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1374        698           137200               0.124 
       2           1325        717           188800               0.118 
       3            858        524           129400               0.101 
       4            869        566            86200               0.159 
       5            848        518            74800               0.201 
       6            955        554           103100               0.118 
       7            924        547            98500               0.155 
       8            760        397            71100               0.159 
       9           1084        631           137200               0.201 
      10            940        605            90700               0.0922
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.624                                         3.14
       2                   0.646                                         2.84
       3                   0.861                                         3.55
       4                   0.693                                         3.28
       5                   0.683                                         3.77
       6                   0.681                                         3.26
       7                   0.614                                         3.40
       8                   0.795                                         3.66
       9                   0.655                                         3.33
      10                   0.747                                         2.69
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.253
       2                                         0.255
       3                                         0.309
       4                                         0.351
       5                                         0.407
       6                                         0.302
       7                                         0.348
       8                                         0.372
       9                                         0.403
      10                                         0.266
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.440                     0.131 
       2                                        0.389                     0.0590
       3                                        0.412                     0.0126
       4                                        0.401                     0.0566
       5                                        0.487                     0.106 
       6                                        0.380                     0.0517
       7                                        0.382                     0.0630
       8                                        0.327                     0.0242
       9                                        0.369                     0.0564
      10                                        0.325                     0.0363
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.364              0.105 
       2                        0.388              0.0635
       3                        0.196              0.0745
       4                        0.262              0.0618
       5                        0.224              0.176 
       6                        0.277              0.0755
       7                        0.255              0.0535
       8                        0.365              0.0295
       9                        0.323              0.0863
      10                        0.299              0.0735
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.864                                 0.0358
       2                           0.862                                 0.0603
       3                           0.860                                 0.0453
       4                           0.763                                 0.128 
       5                           0.764                                 0.0782
       6                           0.860                                 0.0382
       7                           0.815                                 0.0704
       8                           0.790                                 0.0831
       9                           0.755                                 0.137 
      10                           0.802                                 0.0817
         pctHouseholdsWithOverOnePersonPerRoom B11005_001 B11005_002 B11005_005
                                         <dbl>      <dbl>      <dbl>      <dbl>
       1                               0.00979     538944     158757      69810
       2                               0.0224      259165      83455      32447
       3                               0.00219       1824        187         77
       4                               0.0298       23479       8868       3553
       5                               0.0498        8089       2888       1406
       6                               0.0189        5768       1606        610
       7                               0.0269       17318       6605       2524
       8                               0.00765        784        150         49
       9                               0.0397       71748      26503       9784
      10                               0.0286       19320       6941       2256
         B15002_001 B15002_003 B15002_004 B15002_005 B15002_006 B15002_011 B15002_012
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     881312       3397       1566       2758       5945     121577      25215
       2     423230       1816       2010       5509       3491      49320      10505
       3       3157         16         57          7         30        554         89
       4      39742        385        553        886        820       5962       1370
       5      17529        141        151        136        347       3120        434
       6       9907         27         64         38        146       1783        345
       7      28386        128        296        315        290       3988        883
       8       1312          0         20         12         30        152         25
       9     120632       1082       1811       3545       1509      13036       2939
      10      34100        299        373        417        319       5852       1538
         B15002_013 B15002_014 B15002_015 B15002_016 B15002_017 B15002_018 B15002_020
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      57846      24635      70818      28543      14506       6516       4068
       2      35030      13442      35156      19061       6202       5928       1699
       3        329        111        235         30          0         55          0
       4       2512       1151       2035        765        232        113        201
       5       1223        657        678        281         27         86        144
       6        908        231        531        300        121         33          7
       7       2718       1200       1484        629        146         84        171
       8        116         22         91         11         12         10          1
       9       9121       3115       8995       3621        989       1332       1133
      10       2359       1207       1688        624        143         61        294
         B15002_021 B15002_022 B15002_023 B15002_028 B15002_029 B15002_030 B15002_031
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1960       2902       8911     144175      32624      71175      35284
       2       1558       5373       4060      53442      14625      39272      15707
       3          0          5         28        484         95        266        114
       4        601        868        769       5666       1943       3660       1809
       5         36         76        340       3481        601       1175        677
       6         22          2         72       1671        276        973        359
       7         75        293        429       3931       1349       2702       1211
       8          3         11         32        231         16        155         61
       9       1714       4282       1462      13669       3698      10375       4436
      10        174        427        484       5560       1576       2530       1565
         B15002_032 B15002_033 B15002_034 B15002_035 B17010_001 B17010_002 B19001_002
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      77474      38107       8697       3847     319049      39701      54974
       2      38963      20746       4292       3146     159338      18766      21205
       3        284         65          4          0       1076        109        192
       4       2026        966         74         23      16384       2613       2315
       5        560        332         24         30       5734       1150       1139
       6        599        294         41         54       3495        412        567
       7       1722        899        144         47      11606       1795       2024
       8        111         10         14          0        516         82         92
       9       9585       5041        517        584      50020      10040       7426
      10       1504       1027         67         44      13411       1237       1347
         B19001_011 B19001_012 B19001_013 B19001_014 B19001_015 B19001_016 B19001_017
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      42284      50216      57534      35307      18486      16911      17042
       2      21242      26753      29554      18538      10368      10657       7281
       3        154        154        174         21         17         28          2
       4       1885       2267       2481        975        460        354        306
       5        600        859        673        249        128         73         54
       6        533        595        540        228        125         74         71
       7       1365       1819       1698        863        546        296        201
       8         64         68         27         16         34         21          7
       9       5219       6362       6594       3891       1945       1522       1067
      10       1710       1792       2302       1202        791        813        542
         B19113_001 B23001_006 B23001_008 B23001_013 B23001_015 B23001_020 B23001_022
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      58064      16163       5495      11605       2781      17764       3185
       2      59809       8019       1746       8039       1075      11406       1226
       3      40906         37          0          0          0         29          6
       4      43464        963        188        499         39       1079        124
       5      41187        386        199        206         52        306        166
       6      48450        156         30         62         13        149          6
       7      48933        573        147        613         87        967         88
       8      36618         16         16          0          0         19          3
       9      43184       2810        566       2782        461       4694        804
      10      56646        786        219        523         47        764         61
         B23001_027 B23001_029 B23001_034 B23001_036 B23001_041 B23001_043 B23001_048
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      35338       4287      32970       3593      73108       6870      80784
       2      21847       1390      19136        812      37797       1965      37995
       3         36          0         64          0        131         10        192
       4       1552         74       1321         50       3187        242       3172
       5        617        163        436          5       1431        196       1198
       6        329         24        290         18        636         68        813
       7       1372        108       1255          7       2307        118       2606
       8         60          0         12          0         65          0        102
       9       5836        429       4748        235       9460        607      10244
      10       1621         71       1421        157       2779        300       3250
         B23001_050 B23001_055 B23001_057 B23001_062 B23001_064 B23001_069 B23001_071
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       6821      30662       2525      10111        645       9474        606
       2       2052      15184       1016       4563        275       4741        194
       3          6        141         38         27          0         58          0
       4        119       1268        140        533          0        497          0
       5         95        573         70        168          7        165         16
       6         63        545         10        127          0         93          0
       7        139        824          0        344          0        196         18
       8          0         50          3         14          0          4          0
       9        478       4064        193       1137        105        980        106
      10        195       1308         36        465          8        477          7
         B23001_074 B23001_076 B23001_079 B23001_081 B23001_084 B23001_086 B23001_092
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       8213        416       3377        156       3326        150      17584
       2       4234        140       1567         98       1233         69       7801
       3         30          0          5          2         37          0         23
       4        392         25        284          0        229         19        925
       5         67          5         85          0         25          0        245
       6        145          0        106         12         30          0        190
       7        317          0        109          0        147          0        560
       8          2          0         11          0          8          0          7
       9       1111        103        727         14        303         21       2777
      10        316          0        198          0        198          0        722
         B23001_094 B23001_099 B23001_101 B23001_106 B23001_108 B23001_113 B23001_115
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       5196      11833       2458      18930       2655      35817       4172
       2       1117       7104        883      10886        805      18702       1385
       3          0          0          0          0          0         51          0
       4        123        368         18       1108         93       1358         68
       5         71        264        104        199         96        489         82
       6          9        129         14        120         27        247         22
       7         50        566         37        764        136       1180         11
       8          0         31          0          9          0         36          0
       9        595       2732        338       3284        389       4838        479
      10         81        389         26        655         71       1215        151
         B23001_120 B23001_122 B23001_127 B23001_129 B23001_134 B23001_136 B23001_141
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      31432       2650      70255       6163      81085       5375      31874
       2      16094        944      32498       1696      37296       1381      14105
       3          6          0        134         37        198          5         40
       4       1228         59       2740        162       3257        109       1104
       5        535         51       1059        231       1263        186        444
       6        203         45        665         12        857         73        361
       7       1057         45       1901         63       2136         54        850
       8         17          0         61          0        130          0         55
       9       4228        353       9298        814       9975        547       3290
      10       1017         78       2260        119       2868        174       1233
         B23001_143 B23001_148 B23001_150 B23001_155 B23001_157 B23001_160 B23001_162
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1664       9270        533       9569        566       7804        512
       2        448       4325        161       4517        168       3497        163
       3          0         24          0         79          0         28          0
       4         30        482         26        385         10        357          6
       5         11        215         59        137          0         33          0
       6         21        115          7        121         22        123          0
       7         32        182         14        214          0        262          0
       8          0         14          0         15          0          4          0
       9        170       1360        108       1105         32        744         22
      10         28        360         11        291          9        282         21
         B23001_165 B23001_167 B23001_170 B23001_172 B25003_001 B25003_002 B25014_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       3265        190       2764        162     538944     336055     538944
       2       1310         35       1043         36     259165     167303     259165
       3         12          0         14          0       1824       1571       1824
       4        140         14        179         29      23479      16260      23479
       5         60          0         22         10       8089       5528       8089
       6         29          0         50          9       5768       3927       5768
       7        165          0        104          0      17318      10628      17318
       8          2          0          2          0        784        623        784
       9        191         50        181          0      71748      47015      71748
      10        160          0        121         17      19320      14431      19320
         B25014_005 B25014_006 B25014_007 B25014_011 B25014_012 B25014_013 B25044_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1651        136         60       2560        655        214     538944
       2       2157        302         52       2290        709        301     259165
       3          4          0          0          0          0          0       1824
       4        450         45          0        188         16          0      23479
       5        191         68          5         86         25         28       8089
       6         45          0          0         50         14          0       5768
       7        143         69         20         91        102         41      17318
       8          6          0          0          0          0          0        784
       9       1245        162         61       1177        185         20      71748
      10        288         57          0        160         12         36      19320
         B25044_003 B25044_010 B25064_001 B25077_001 B25088_002 C17002_001 C17002_002
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      15883      54800        698     137200       1374    1267165      96265
       2       3715      11577        717     188800       1325     638074      45634
       3         13         10        524     129400        858       3626        247
       4        366        963        566      86200        869      62311       3631
       5        327        529        518      74800        848      25085       2330
       6         54        244        554     103100        955      13361        734
       7        291        800        547      98500        924      45352       3535
       8         11          8        397      71100        760       1772         95
       9       1219       2829        631     137200       1084     195272      16998
      10        419        283        605      90700        940      51574       2430
         C17002_003 C17002_004 C17002_005 C24010_001 C24010_003 C24010_039
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     111361      59367      53958     594551     101196     114959
       2      53984      32392      30852     313659      59494      62161
       3        309        273        290       1292         80        173
       4       9446       5071       3729      26840       3136       3896
       5       3701       2227       1964       8753        771       1187
       6       1558       1018        719       6186        903        808
       7       5582       3412       3234      20417       2365       2837
       8        288        128        148        724        142        122
       9      30807      14773      16030      84880      13098      14306
      10       4579       3573       3120      23792       3151       3974
      # i 24 more rows

---

    Code
      get_adi(geography = "state", year = 2009, dataset = "acs1", keep_indicators = TRUE,
        cache_tables = FALSE)
    Message
      
      1 call(s) to tidycensus beginning.
      Getting data from the 2009 1-year ACS
      The 1-year ACS provides data for geographies with populations of 65,000 and greater.
    Output
      # A tibble: 52 x 131
         GEOID NAME                   ADI Financial_Strength
         <chr> <chr>                <dbl>              <dbl>
       1 01    Alabama              120.                81.5
       2 02    Alaska                76.6              117. 
       3 04    Arizona              106.                98.8
       4 05    Arkansas             123.                74.6
       5 06    California            89.7              132. 
       6 08    Colorado              87.3              111. 
       7 09    Connecticut           75.7              130. 
       8 10    Delaware              87.1              112. 
       9 11    District of Columbia  86.0              150. 
      10 12    Florida              105.                99.7
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                            114.                    91.8              50779
       2                             83.9                  106.               79934
       3                            105.                    84.6              57855
       4                            114.                    86.4              46868
       5                             99.2                   51.4              67038
       6                             88.1                  110.               68943
       7                             84.2                  109.               83069
       8                             88.3                  110.               67582
       9                            144.                   102.               71208
      10                            107.                    96.6              53509
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1110        657           119600               0.134 
       2           1789       1007           232900               0.0616
       3           1490        859           187700               0.116 
       4            959        606           102900               0.148 
       5           2317       1155           384200               0.106 
       6           1607        851           237800               0.0889
       7           2079       1006           291200               0.0668
       8           1572        949           249400               0.0708
       9           2231       1059           443700               0.146 
      10           1565        952           182400               0.107 
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.696                                         3.29
       2                   0.652                                         1.87
       3                   0.671                                         2.77
       4                   0.660                                         3.35
       5                   0.566                                         2.30
       6                   0.670                                         2.51
       7                   0.688                                         2.26
       8                   0.736                                         2.25
       9                   0.448                                         3.02
      10                   0.685                                         2.88
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.285
       2                                         0.160
       3                                         0.266
       4                                         0.309
       5                                         0.241
       6                                         0.206
       7                                         0.148
       8                                         0.181
       9                                         0.255
      10                                         0.253
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.385                     0.0633
       2                                        0.329                     0.0969
       3                                        0.347                     0.0675
       4                                        0.367                     0.0672
       5                                        0.318                     0.0757
       6                                        0.284                     0.0563
       7                                        0.312                     0.0831
       8                                        0.367                     0.0777
       9                                        0.615                     0.352 
      10                                        0.370                     0.0658
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.320              0.111 
       2                        0.342              0.0947
       3                        0.338              0.106 
       4                        0.303              0.0914
       5                        0.364              0.113 
       6                        0.392              0.0850
       7                        0.403              0.0923
       8                        0.381              0.0861
       9                        0.572              0.111 
      10                        0.332              0.121 
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.821                                 0.0602
       2                           0.914                                 0.0304
       3                           0.842                                 0.0708
       4                           0.824                                 0.0712
       5                           0.806                                 0.105 
       6                           0.893                                 0.0463
       7                           0.886                                 0.0466
       8                           0.874                                 0.0388
       9                           0.871                                 0.0476
      10                           0.853                                 0.0595
         pctHouseholdsWithOverOnePersonPerRoom B11005_001 B11005_002 B11005_005
                                         <dbl>      <dbl>      <dbl>      <dbl>
       1                                0.0191    1848051     606004     233606
       2                                0.0578     236597      88388      29039
       3                                0.0411    2276865     767251     266458
       4                                0.0258    1124947     377913     138586
       5                                0.0823   12214891    4566138    1449930
       6                                0.0221    1910146     621644     176403
       7                                0.0204    1326329     452171     141167
       8                                0.0179     327252     105886      38870
       9                                0.0295     249280      52516      32298
      10                                0.0243    6987647    2050607     758415
         B15003_001 B15003_002 B15003_003 B15003_004 B15003_005 B15003_006 B15003_007
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    3115982      37751        208        264       1851       4339       8433
       2     431178       3122          0          0         54        563        954
       3    4248231      55276        120        488       4008       6745      18429
       4    1903914      26335         55         38       1047       3587       5835
       5   23782109     557643       4507       7985      39215      96279     195621
       6    3293368      28180        512        732       1665       2190       8374
       7    2370028      20979        102        409       1067       2695       5922
       8     595133       5136          0          0        195        359        927
       9     413396       4559        132         75        278       1023       1115
      10   12800944     170336       2405       2465      11731      22732      38341
         B15003_008 B15003_009 B15003_010 B15003_011 B15003_012 B15003_017 B15003_018
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       5664       9836      32484      29292      57335     797598     169314
       2        733        973       1303        958       4434      95366      24129
       3      15981      16657      87842      22804      72246     891969     165360
       4       5855       6054      22858      18961      44975     544562     118109
       5     129852     168896     827155     144659     333854    4457919     521657
       6       7070      10215      41695      12683      39281     621150     122657
       7       6753       7964      19439      10900      34319     589020      78755
       8       1181        732       3560       3352       7646     165267      20327
       9        844       1377       3295       3285       3681      71520      11314
      10      34060      55900     170579      73430     179457    3315145     548249
         B15003_019 B15003_020 B15003_021 B15003_022 B15003_023 B15003_024 B15003_025
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     187044     499367     218551     447402     168782      43137      27222
       2      37554      89990      32532      75816      28369       6328       4022
       3     329783     772503     330543     691996     279698      67951      46108
       4     128509     303367     115017     242389      83186      21009      12349
       5    1408419    3876236    1797763    4553969    1685526     535673     335281
       6     209006     545618     261847     762038     305896      71046      42614
       7     125561     287284     174809     475179     267418      66317      34588
       8      37374      81860      44146     103335      46372      11841       9543
       9      16668      49467      10728      84646      64982      34211      16543
      10     834192    1902098    1083545    2081848     774248     251389     126229
         B17010_001 B17010_002 B19001_002 B19001_011 B19001_012 B19001_013 B19001_014
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    1246056     166703     201765     146422     167427     192497     106449
       2     159940       9850       9801      18631      26897      38354      26161
       3    1514235     175498     176945     192893     242445     274108     163741
       4     768492     113410     120726      95104     101643     100513      57084
       5    8366253     887411     695403     948345    1206377    1547756    1085712
       6    1233139     109626     128321     158819     201706     252161     165773
       7     890530      59484      78653      95621     133968     176454     136585
       8     220655      15627      17477      30582      35166      43741      28295
       9     109030      15965      28804      17590      20622      27231      18769
      10    4542466     488257     558840     583638     704962     747850     429354
         B19001_015 B19001_016 B19001_017 B19113_001 B23001_006 B23001_008 B23001_013
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      54623      46270      39363      50779      53850      17500      48685
       2      15154      14104      11137      79934      10640       2896       9542
       3      91858      75970      69126      57855      71682      20899      68947
       4      26269      20984      19928      46868      33097       8681      32805
       5     693943     748264     721754      67038     364113     129114     386263
       6      95643      93588      78500      68943      63372      18193      59472
       7      84884      92058     104339      83069      44657      13095      34375
       8      18017      16072      12583      67582      10515       3522       7713
       9      13547      18108      25135      71208       2779       1224       5738
      10     231761     214297     215494      53509     174949      61953     188259
         B23001_015 B23001_020 B23001_022 B23001_027 B23001_029 B23001_034 B23001_036
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      12372      69905      14362     139758      19575     121115      11139
       2       1792      13361       1959      22737       3076      20816       2223
       3      14147     106132      16354     213984      24471     208646      21101
       4       6632      47271       8771      81031       9305      78971       6555
       5      90654     611177     107500    1234444     153372    1188656     121658
       6      12074      88346      13184     169110      17632     161917      12739
       7       5930      53653       8971      93262      12120      88879       7548
       8       1297      13972       1867      24801       1474      24592       1929
       9       1600       7659       1563      23596       1412      22977       1954
      10      42781     266683      44897     536217      78015     504257      56760
         B23001_041 B23001_043 B23001_048 B23001_050 B23001_055 B23001_057 B23001_062
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     258235      20102     262536      22540     101931       8201      33092
       2      37459       3775      47239       3560      20467       1922       4636
       3     392867      38515     354925      34578     128945      12689      45147
       4     157115       9909     157804      11899      65574       2745      17790
       5    2381084     212478    2248210     207114     797746      73353     256934
       6     330522      20193     328224      23637     126837       9355      40183
       7     220223      17388     248101      17520      91083       6404      32284
       8      50442       3275      54286       4751      20680       1635       6195
       9      38922       3439      30189       4267      11247       1377       4655
      10    1075147     113834    1089729     117491     393501      42757     141446
         B23001_064 B23001_069 B23001_071 B23001_074 B23001_076 B23001_079 B23001_081
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1412      31935       1681      28149       2045      12868        634
       2        367       4903        421       3765        187       1440         54
       3       4029      45729       4118      36443       3284      17357       1333
       4        743      19816       1434      17665       1466       8050        234
       5      22684     269367      26838     217507      18150      88013       6204
       6       3140      43398       3195      30274       2561      14372       1097
       7       2145      33550       2401      31275       2789      12544       1474
       8        335       7678        590       5916        411       2936        243
       9        479       4848        534       4145        625       2417         66
      10      15516     159868      16329     134791      13774      63209       6945
         B23001_084 B23001_086 B23001_092 B23001_094 B23001_099 B23001_101 B23001_106
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       9223        581      50237      16439      40851       8163      69180
       2        975         56      10715       3077       7634        899      11012
       3      13775       1491      69403      16671      58836       9683      88253
       4       5366        123      30797       7102      29480       3781      36775
       5      59275       4673     353593     108559     350736      59684     526868
       6       8492        376      58946      13486      51621       6064      77866
       7       9099        570      48250       9704      33049       5162      51996
       8       2233        177      10784       2133       8539        930      12783
       9       1309          0       5754       2599       4810       1107      11401
      10      53288       4164     172025      52293     166807      30192     248929
         B23001_108 B23001_113 B23001_115 B23001_120 B23001_122 B23001_127 B23001_129
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      10413     119558      17969     115081      12235     233806      21194
       2        868      20235       1453      13620        680      34809       2861
       3      10533     175492      15320     159184      15105     315274      26954
       4       5234      78284       7608      65995       6638     142307       9845
       5      71309     998223     115734     919678      93527    1893590     182038
       6       7488     140483      11926     130136       8718     265969      16952
       7       5404      89412      10609      82515       6233     194422      13955
       8       1851      23630       2094      23517       1445      48157       3596
       9       1877      27408       2934      24372       2120      34310       2975
      10      39875     469551      52597     424596      45971     945480      93987
         B23001_134 B23001_136 B23001_141 B23001_143 B23001_148 B23001_150 B23001_155
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     244708      17183      87312       5946      31090       1997      28890
       2      42570       1756      16185        581       4123        135       3185
       3     310399      25704     116666       7600      41832       2938      39893
       4     146768      11471      58221       3468      17753        370      17421
       5    1938110     172777     717259      54083     223616      18455     231768
       6     296699      15856     113902       6431      33632       2162      36695
       7     231928      14693      87856       5965      29320       1742      32684
       8      53866       2592      19718       1502       7450        366       6196
       9      30479       2768      13686       1010       5215        106       4767
      10    1035892      91506     390448      33904     131275      11488     134323
         B23001_157 B23001_160 B23001_162 B23001_165 B23001_167 B23001_170 B23001_172
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1874      24647       1371      10507        276       6421        332
       2         68       3346        130       1880         78       1044          0
       3       2385      31546       1747      11020        735       6123        798
       4        730      13669        497       6590         64       4813          0
       5      16484     176000      12904      67029       4847      42059       2547
       6       2044      24819       1409       9443        435       5918        188
       7       1728      27450       2369       9154        820       6725        247
       8        449       5895        520       2741         55       1767        290
       9        216       5172        296       1297        132       1455          0
      10      13159     113031      10337      46517       4783      33437       3260
         B25003_001 B25003_002 B25014_001 B25014_005 B25014_006 B25014_007 B25014_011
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    1848051    1285879    1848051      12340       2441        762      14671
       2     236597     154337     236597       4919       1431       1129       3433
       3    2276865    1526790    2276865      25132       8493       3065      40245
       4    1124947     742860    1124947      10654       2063        352      10613
       5   12214891    6910054   12214891     213753      49747      14943     416951
       6    1910146    1279955    1910146      11373       2193        772      20326
       7    1326329     913166    1326329       6072       1117        424      13408
       8     327252     240908     327252       1830         75         49       2198
       9     249280     111618     249280        970        334        159       3901
      10    6987647    4785064    6987647      50859       9213       2790      74118
         B25014_012 B25014_013 B25044_001 B25044_003 B25044_010 B25064_001 B25077_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       3012       2007    1848051      38002      78889        657     119600
       2       2004        755     236597       9861      13055       1007     232900
       3      13165       3394    2276865      42430     111347        859     187700
       4       3890       1417    1124947      20110      55433        606     102900
       5     204410     105749   12214891     181566     742846       1155     384200
       6       6142       1339    1910146      26227      81320        851     237800
       7       4304       1689    1326329      20928      89245       1006     291200
       8       1372        348     327252       9395      16031        949     249400
       9       1400        599     249280      17209      70497       1059     443700
      10      25653       6952    6987647     158254     301786        952     182400
         B25088_002 C17002_001 C17002_002 C17002_003 C17002_004 C17002_005 C24010_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1110    4588899     343928     460755     248628     254423    1986034
       2       1789     682412      27286      34367      21814      25636     333464
       3       1490    6475485     490820     579077     322402     330266    2795318
       4        959    2806056     215636     311742     168150     170662    1245923
       5       2317   36202780    2172632    2956076    1779512    1833577   16454578
       6       1607    4917061     290156     344231     189760     188112    2480113
       7       2079    3409901     149816     170738      85154      98370    1740760
       8       1572     860972      42162      51089      32690      29685     417673
       9       2231     570093      61128      43773      18010      22583     293927
      10       1565   18124789    1180365    1527560     920351     954612    7995087
         C24010_003 C24010_040
              <dbl>      <dbl>
       1     284468     350741
       2      52013      62160
       3     463385     481318
       4     167981     209633
       5    3035799    2960881
       6     493757     478966
       7     345100     356901
       8      72845      86170
       9      82569      85657
      10    1261003    1396324
      # i 42 more rows

---

    Code
      get_adi(geography = "state", year = 2008, dataset = "acs3", keep_indicators = TRUE,
        cache_tables = FALSE)
    Message
      
      1 call(s) to tidycensus beginning.
      Getting data from the 2006-2008 3-year ACS
      The 3-year ACS provides data for geographies with populations of 20,000 and greater.
    Output
      # A tibble: 52 x 135
         GEOID NAME                   ADI Financial_Strength
         <chr> <chr>                <dbl>              <dbl>
       1 01    Alabama              118.                80.8
       2 02    Alaska                83.5              115. 
       3 04    Arizona              101.               102. 
       4 05    Arkansas             122.                75.0
       5 06    California            88.3              138. 
       6 08    Colorado              87.8              111. 
       7 09    Connecticut           75.9              130. 
       8 10    Delaware              89.7              110. 
       9 11    District of Columbia  95.5              145. 
      10 12    Florida               99.2              104. 
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                            111.                    91.6              53144
       2                             94.0                  103.               77020
       3                             98.9                   84.9              60426
       4                            114.                    87.9              48098
       5                             97.6                   57.1              69659
       6                             89.2                  110.               69745
       7                             84.9                  111.               84657
       8                             91.6                  110.               68541
       9                            148.                    98.5              67308
      10                             99.9                   98.6              58339
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1080        620           114700               0.125 
       2           1744        945           226900               0.0670
       3           1496        847           234600               0.102 
       4            964        601            99600               0.132 
       5           2354       1118           510200               0.0965
       6           1631        833           236300               0.0827
       7           2056        959           305100               0.0602
       8           1527        916           239700               0.0710
       9           2159        979           453900               0.145 
      10           1584        946           226300               0.0899
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.713                                         3.17
       2                   0.641                                         1.81
       3                   0.683                                         2.55
       4                   0.678                                         3.26
       5                   0.578                                         2.18
       6                   0.683                                         2.42
       7                   0.696                                         2.11
       8                   0.735                                         2.31
       9                   0.446                                         3.01
      10                   0.703                                         2.65
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.268
       2                                         0.168
       3                                         0.240
       4                                         0.296
       5                                         0.226
       6                                         0.198
       7                                         0.139
       8                                         0.174
       9                                         0.252
      10                                         0.222
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.364                     0.0661
       2                                        0.328                     0.102 
       3                                        0.342                     0.0633
       4                                        0.352                     0.0661
       5                                        0.312                     0.0749
       6                                        0.289                     0.0570
       7                                        0.295                     0.0836
       8                                        0.360                     0.0651
       9                                        0.616                     0.355 
      10                                        0.357                     0.0643
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.310              0.0680
       2                        0.344              0.0867
       3                        0.329              0.0562
       4                        0.295              0.0692
       5                        0.354              0.0691
       6                        0.375              0.0529
       7                        0.395              0.0617
       8                        0.361              0.0597
       9                        0.555              0.0809
      10                        0.323              0.0637
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.809                                 0.0634
       2                           0.906                                 0.0358
       3                           0.837                                 0.0737
       4                           0.812                                 0.0714
       5                           0.803                                 0.106 
       6                           0.886                                 0.0461
       7                           0.882                                 0.0469
       8                           0.867                                 0.0441
       9                           0.853                                 0.0572
      10                           0.849                                 0.0572
         pctHouseholdsWithOverOnePersonPerRoom B11005_001 B11005_002 B11005_005
                                         <dbl>      <dbl>      <dbl>      <dbl>
       1                                0.0183    1811009     614699     223825
       2                                0.0627     235500      89947      29479
       3                                0.0440    2250241     760090     260230
       4                                0.0237    1106185     376392     132401
       5                                0.0775   12177852    4631915    1446610
       6                                0.0222    1866621     628776     181612
       7                                0.0172    1325680     452625     133708
       8                                0.0145     325746     108627      39114
       9                                0.0275     250423      53697      33051
      10                                0.0253    7080705    2123720     759016
         B15002_001 B15002_003 B15002_004 B15002_005 B15002_006 B15002_011 B15002_012
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1    3052298      14117      12899      22906      47598     462999      76041
       2     422721       1122        982       1846       3597      66000      15732
       3    4082038      21351      22425      58029      55475     519559     136293
       4    1863115       9340       8693      16683      33408     322185      53467
       5   23237728     210009     219874     502669     261890    2556783     615684
       6    3189198      12652      12302      29230      26117     382191      87057
       7    2352649       7415       7587      12669      24346     325281      58133
       8     573425       1893       1732       3388       6317      88175      16850
       9     401222       2292       2318       3221       3778      37269       5651
      10   12566850      54870      55237     118042     134061    1799733     366407
         B15002_013 B15002_014 B15002_015 B15002_016 B15002_017 B15002_018 B15002_020
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     208518      86253     204577      71636      26590      17049      12977
       2      43431      16602      32673      13349       4590       3576       1110
       3     338553     145104     330527     129237      41686      27526      22975
       4     127272      41190     112775      34452      14662       9548       7835
       5    1688395     800285    2142743     813690     302261     210556     253862
       6     245680     111534     357680     141773      40861      27097       9129
       7     128824      70120     227323     115366      38371      21758       9269
       8      35383      17324      43894      19524       5589       5368       2082
       9      18776       5519      41668      27256      14634       7752       2250
      10     803556     464285    1043462     360846     161123      74757      60004
         B15002_021 B15002_022 B15002_023 B15002_028 B15002_029 B15002_030 B15002_031
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       8961      22417      51614     518520     101927     239714     117963
       2       1390       2183       2903      54538      16143      40932      17501
       3      19079      48004      53591     547840     163941     358526     173451
       4       7043      13498      36481     344129      65982     144302      63347
       5     230104     506751     275388    2637749     736320    1803292     974570
       6       9252      22835      25567     386092     107386     260463     128539
       7       8643      14566      25851     354991      70923     145260     103756
       8        990       2463       6407      99838      21298      39389      25092
       9       2050       3227       3812      45775       8859      22792       8059
      10      50617     111996     133953    2068985     451002     891785     596218
         B15002_032 B15002_033 B15002_034 B15002_035 B17010_001 B17010_002 B19001_002
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     212722      98646      16157       8948    1232769     154133     185355
       2      38310      15034       2794       1679     159522      10685       9038
       3     327824     137188      25471      15209    1483518     150842     147532
       4     119436      46412       9009       4572     753559      99708     112178
       5    2236397     811885     209890     109028    8289681     799936     629950
       6     359837     148526      25800      14455    1200433      99225     116988
       7     237131     140110      26691      11959     889222      53523      69602
       8      49225      23472       4362       2221     220065      15628      18573
       9      43607      34094      13170       7214     107697      15623      27976
      10    1059117     389633      94555      44497    4603986     414062     488108
         B19001_011 B19001_012 B19001_013 B19001_014 B19001_015 B19001_016 B19001_017
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     151573     173388     194202     112176      55958      48506      42006
       2      18545      26341      36693      25563      16408      14191      10089
       3     193239     242090     283880     170972      95977      83945      79100
       4      93342     101674     108455      54360      29026      22644      20364
       5     939030    1225861    1568948    1110483     714479     775108     794021
       6     153936     202484     246717     162468      97515      92834      84199
       7      98896     134589     188001     135253      85996      89707     107991
       8      28460      35976      45497      28869      16839      16321      12548
       9      17379      21259      27056      18138      13540      16971      23282
      10     616927     742181     827249     489637     267027     247003     261519
         B19113_001 B23001_006 B23001_008 B23001_013 B23001_015 B23001_020 B23001_022
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      53144      56733      15071      50118       7080      72213       7857
       2      77020      11460       2856       9730       1761      12321       1297
       3      60426      81344      15391      69720       7761     103293       8575
       4      48098      38592      10576      28600       4524      43320       4942
       5      69659     421960     106951     403138      56372     637797      65810
       6      69745      65011      13937      55122       5428      84295       6721
       7      84657      45986      10862      35161       4360      52107       5803
       8      68541      11194       2366       9183       1339      13809       1575
       9      67308       3972       1140       5254       1156      10584       1397
      10      58339     203395      47848     179552      22557     265735      27253
         B23001_027 B23001_029 B23001_034 B23001_036 B23001_041 B23001_043 B23001_048
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     129295      10027     119691       6323     267708      11570     260446
       2      21685       2762      18454       1300      42069       3021      46725
       3     213824      11070     200461       8729     385897      17003     345115
       4      79920       5798      76424       4444     160821       8052     155527
       5    1178019      87655    1162575      61338    2439405     113753    2166516
       6     170911       7601     162856       5603     335028      12863     324142
       7      87093       6883      90915       4565     234961      10544     244010
       8      23634       1434      22611       1212      53836       2317      52465
       9      23025       2435      21065       1296      36615       2120      29737
      10     515719      34542     488780      24419    1116967      49802    1063526
         B23001_050 B23001_055 B23001_057 B23001_062 B23001_064 B23001_069 B23001_071
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       9422      97169       3780      31701        921      27274        862
       2       3206      17285        996       5346        418       4376        168
       3      13189     128598       5466      39602       1607      37989       1486
       4       7140      60295       2318      18034        476      18762        797
       5     108232     757776      37362     229222      12497     222376      10191
       6      12214     119997       5147      36486       1372      35275       1069
       7      10206      88354       3693      27602       1195      30128       1173
       8       2452      19365        605       6319        186       6490        268
       9       2536      11642        480       3777        232       3710        119
      10      50029     398993      19581     127274       5512     135488       5871
         B23001_074 B23001_076 B23001_079 B23001_081 B23001_084 B23001_086 B23001_092
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      26371        729      12639        510       8456        262      50668
       2       3283        135       1200         16        995        177      11699
       3      35435       1369      15303        592      11669        711      72180
       4      16202        567       8435        204       5586        118      34144
       5     195652       9360      86333       3786      61393       2577     403813
       6      28445        808      12690        351       8079        260      62636
       7      26161       1226      11747        600       8811        339      49209
       8       5144        221       2537        124       1950        128      11562
       9       4026         95       1942         73       1660         98       5409
      10     123563       5937      62291       3166      52970       3034     190579
         B23001_094 B23001_099 B23001_101 B23001_106 B23001_108 B23001_113 B23001_115
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      12182      43807       6813      66604       8997     115538      10851
       2       2353       7378       1546      10150       1377      17227       1619
       3      12615      59080       6020      83464       6157     162360      10004
       4       7110      25230       3060      39621       3773      71516       6974
       5      87452     350946      41951     547484      53022     910296      69351
       6      11309      46295       4799      71822       6176     140759       8337
       7       9590      32637       3879      49482       4746      81125       4846
       8       2102       8632        766      12222        919      22019       1278
       9       1399       4700        991      14395        990      25962       2330
      10      37678     156420      18047     243922      23113     432592      31854
         B23001_120 B23001_122 B23001_127 B23001_129 B23001_134 B23001_136 B23001_141
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     105214       7720     237168      12454     239242      10351      86185
       2      15906        908      37534       2509      42052       1856      13714
       3     144099       7384     307825      15022     305248      12186     114930
       4      64404       5178     143631       7312     144243       6163      53046
       5     863549      57683    1899688     113477    1859392      95324     658447
       6     122268       5480     270171      11404     287173      11542     101935
       7      79830       4363     206153      10560     224921       9914      83846
       8      21246       1040      48299       2781      51146       1976      17814
       9      21459        934      34527       2850      31514       2314      12676
      10     403479      24225     967788      51058     990896      46572     381819
         B23001_143 B23001_148 B23001_150 B23001_155 B23001_157 B23001_160 B23001_162
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       2375      25105        793      23113        490      20661        957
       2        660       3536        215       3310         54       2581        116
       3       4384      33092        862      34133        823      27279       1123
       4       1363      17164        640      16667        412      13641        660
       5      27951     193109       8604     184106       7981     150278       7154
       6       3723      29809       1243      28760        787      19652        542
       7       3039      26463       1063      26693       1196      21695        768
       8        602       5793         94       6188        228       4019        235
       9        702       4234        103       4632        228       3872         37
      10      17154     119707       5402     114889       4799     100260       4350
         B23001_165 B23001_167 B23001_170 B23001_172 B25003_001 B25003_002 B25014_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       9163        183       5577        285    1811009    1291690    1811009
       2        714          7        576          0     235500     151032     235500
       3      10895        420       7533        207    2250241    1537334    2250241
       4       6265        214       4077        172    1106185     750243    1106185
       5      59531       2351      41936       1686   12177852    7038202   12177852
       6       9064        309       5038        202    1866621    1274562    1866621
       7       8838        407       7346        290    1325680     922353    1325680
       8       1954         48       1233         19     325746     239462     325746
       9       1454         67       1343         29     250423     111645     250423
      10      44458       2160      33479       1644    7080705    4975344    7080705
         B25014_005 B25014_006 B25014_007 B25014_011 B25014_012 B25014_013 B25044_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      11947       2886       1214      13237       2975        865    1811009
       2       4501       1917        780       4987       1956        628     235500
       3      31797       8678       2945      38271      13572       3768    2250241
       4       9227       1476        636      11689       2580        662    1106185
       5     218553      51775      14228     422432     171370      65765   12177852
       6      11801       2621        482      19311       5381       1816    1866621
       7       6009        706        338      11602       3510        619    1325680
       8       1608        141         94       2065        684        127     325746
       9        711        270        109       3192       2047        554     250423
      10      54262      11955       5121      80605      21088       6280    7080705
         B25044_003 B25044_010 B25064_001 B25077_001 B25088_002 C17002_001 C17002_002
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      42706      77045        620     114700       1080    4504542     310833
       2       8724      15190        945     226900       1744     664501      26264
       3      40577     101794        847     234600       1496    6222824     407714
       4      21271      51841        601      99600        964    2747711     186183
       5     188901     723316       1118     510200       2354   35641425    1902375
       6      25217      81241        833     236300       1631    4738973     250032
       7      22164      88644        959     305100       2056    3380838     128326
       8       6277      14940        916     239700       1527     837791      39728
       9      16761      72249        979     453900       2159     558593      53990
      10     162186     292903        946     226300       1584   17774469     939717
         C17002_003 C17002_004 C17002_005 C24010_001 C24010_003 C24010_040
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1     424429     232566     241091    2038994     293788     337400
       2      36599      24624      23886     329973      53142      60528
       3     484475     293493     309493    2860212     467250     474505
       4     296246     164850     164792    1251180     168227     201152
       5    2710387    1726698    1726547   16834866    3067947    2899550
       6     312016     185339     190539    2494492     481309     453472
       7     159511      90340      93222    1765164     342215     355145
       8      47513      28479      29905     414349      71728      77911
       9      45253      20196      21064     297035      78352      86613
      10    1307421     818716     874508    8346934    1305599    1388228
      # i 42 more rows

---

    Code
      get_adi(geography = "county", state = "NM", year = 2000, dataset = "decennial",
        keep_indicators = TRUE, cache_tables = FALSE)
    Message
      
      2 call(s) to tidycensus beginning.
      Getting data from the 2000 decennial Census
      Using Census Summary File 1
      Getting data from the 2000 decennial Census
      Using Census Summary File 3
      Using Census Summary File 3
    Output
      # A tibble: 33 x 88
         GEOID NAME                            ADI Financial_Strength
         <chr> <chr>                         <dbl>              <dbl>
       1 35001 Bernalillo County, New Mexico  77.6              125. 
       2 35003 Catron County, New Mexico     101.                94.0
       3 35005 Chaves County, New Mexico     109.                89.6
       4 35006 Cibola County, New Mexico     113.                88.6
       5 35007 Colfax County, New Mexico      91.9               96.8
       6 35009 Curry County, New Mexico      101.                92.8
       7 35011 De Baca County, New Mexico    103.                90.1
       8 35013 Dona Ana County, New Mexico   109.               101. 
       9 35015 Eddy County, New Mexico        99.5               91.9
      10 35017 Grant County, New Mexico       98.4               97.7
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                             85.2                  120.               46613
       2                            100.                   110.               30742
       3                            106.                    87.8              32532
       4                            118.                    94.7              30714
       5                             88.8                  119.               36827
       6                            101.                   109.               33900
       7                             91.4                   91.9              32870
       8                            108.                    72.7              33576
       9                             91.6                  100.               36789
      10                             99.8                  110.               34231
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1045        560           123200                0.102
       2            646        392            81200                0.174
       3            618        402            56700                0.176
       4            654        355            54400                0.215
       5            693        414            73900                0.120
       6            662        427            61800                0.155
       7            606        371            51300                0.136
       8            833        445            74000                0.202
       9            685        394            60900                0.136
      10            716        419            82600                0.151
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.637                                         3.24
       2                   0.806                                         4.68
       3                   0.709                                         4.09
       4                   0.770                                         4.33
       5                   0.726                                         3.77
       6                   0.594                                         4.07
       7                   0.780                                         4.52
       8                   0.675                                         4.00
       9                   0.743                                         3.86
      10                   0.744                                         4.12
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.236
       2                                         0.395
       3                                         0.367
       4                                         0.390
       5                                         0.269
       6                                         0.339
       7                                         0.327
       8                                         0.404
       9                                         0.311
      10                                         0.331
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.356                     0.0683
       2                                        0.264                     0.0455
       3                                        0.343                     0.0757
       4                                        0.406                     0.0862
       5                                        0.336                     0.0624
       6                                        0.316                     0.0786
       7                                        0.204                     0.0770
       8                                        0.336                     0.0632
       9                                        0.308                     0.0620
      10                                        0.359                     0.0669
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.379              0.0582
       2                        0.310              0.0890
       3                        0.276              0.0903
       4                        0.296              0.115 
       5                        0.296              0.0642
       6                        0.274              0.0687
       7                        0.327              0.0540
       8                        0.323              0.0920
       9                        0.251              0.0676
      10                        0.299              0.0802
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.844                                 0.0604
       2                           0.784                                 0.0734
       3                           0.726                                 0.141 
       4                           0.750                                 0.0930
       5                           0.808                                 0.0626
       6                           0.784                                 0.0789
       7                           0.723                                 0.141 
       8                           0.700                                 0.182 
       9                           0.750                                 0.108 
      10                           0.794                                 0.0918
         pctHouseholdsWithOverOnePersonPerRoom P015001 H004001 H004002 H020001 H020005
                                         <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1                                0.0559  220936  220936  140634  220936    3161
       2                                0.0606    1584    1584    1276    1584      47
       3                                0.0768   22561   22561   16000   22561     580
       4                                0.117     8327    8327    6414    8327     435
       5                                0.0297    5821    5821    4224    5821      80
       6                                0.0570   16766   16766    9958   16766     309
       7                                0.0434     922     922     719     922      11
       8                                0.109    59556   59556   40208   59556    2301
       9                                0.0525   19379   19379   14391   19379     441
      10                                0.0419   12146   12146    9041   12146     213
         H020006 H020007 H020011 H020012 H020013 H044001 H044003 H044010 H063001
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1    1291     409    3919    2438    1132  220936    4364   10729     560
       2      26       0      19       2       2    1584      45      27     392
       3     411      96     364     211      70   22561     622    1086     402
       4     170      97     154      74      41    8327     420     298     355
       5      12       9      33      27      12    5821     165     198     414
       6     103      39     297     155      53   16766     401     916     427
       7       6       0      10      13       0     922      27      44     371
       8    1306     461    1245     728     474   59556    1449    2314     445
       9     160      85     140     142      49   19379     538     664     394
      10      67      35     142      35      17   12146     345     468     419
         H085001 H091001 P019002 P019005 P037001 P037003 P037004 P037005 P037006
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1  123200    1045   76848   27338  358680    2053    1209    3821    3836
       2   81200     646     390     103    2657      16      10      13      59
       3   56700     618    8979    3077   37811     677     397     872     767
       4   54400     654    3791    1538   15273     100      87      95     351
       5   73900     693    1931     649    9518      59      49      40     170
       6   61800     662    6923    2186   26403     158     146     259     382
       7   51300     606     275      56    1584      22      10      24      62
       8   74000     833   25588    8591   99893    1900    1458    2979    1794
       9   60900     685    7688    2370   32572     480     234     371     624
      10   82600     716    4259    1530   20350     124      60     171     477
         P037011 P037012 P037013 P037014 P037015 P037016 P037017 P037018 P037020
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1   40001   10946   27283    9362   30646   15750    5173    4862    1997
       2     401     111     201      88     161      74       6      12      16
       3    4700    1521    2509     994    1798     907     354      94     541
       4    2757     601     961     361     561     210      72      14     206
       5    1545     302     636     258     621     227      53      24      23
       6    3541    1123    2350    1035    1212     450     218      58     205
       7     229      51     109      16      87      38       0       0      15
       8   10541    2644    6681    2473    6688    2841     752    1157    2260
       9    5268    1182    2156     686    1469     569     139      56     481
      10    2945     658    1690     490    1119     626     142     134     162
         P037021 P037022 P037023 P037028 P037029 P037030 P037031 P037032 P037033
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1    1238    3111    4409   48852   14846   31045   11051   31820   15791
       2       5      18      58     369      79     258      87     173      55
       3     328     909     852    5298    1740    3244    1295    1907     840
       4     105     115     361    2828     651     960     507     563     315
       5      33      69     153    1713     402     752     319     571     208
       6     146     288     500    3830    1281    2448    1063    1334     639
       7      14      27      50     246      83     114      41      90      34
       8    1789    3852    2154   11863    3324    7256    2920    6352    3582
       9     185     426     718    5920    1496    2313    1005    1363     646
      10     156     177     541    2977     848    1751     622    1210     742
         P037034 P037035 P043005 P043007 P043012 P043014 P050001 P050003 P050050
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1    3504    1890  146539    8719  132274    7506  262588   50705   48866
       2       5       2     802      80     592      44    1270     220     174
       3     174      58   14067    1132   11246    1153   23028    3131    3222
       4      77      23    4942     553    4890     576    8703     984    1593
       5      57       2    3496     215    2964     200    6045     830     958
       6     104      17    9617     578    8619     675   16983    2157    2504
       7       8       0     518      21     426      30     893     143     149
       8     514     383   40395    3594   34151    3267   67685   10954   10901
       9     129      22   12383     896    9702     598   20591    2421    2755
      10     133      74    6585     608    5823     387   11413    1568    1844
         P052002 P052011 P052012 P052013 P052014 P052015 P052016 P052017 P077001
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1   21249   18970   20765   20950   10085    4854    3917    3936   46613
       2     333     108      93      65      29       8       3       2   30742
       3    3282    1616    1566    1232     506     160     178     252   32532
       4    1360     571     587     402     112      56      23      43   30714
       5     653     426     534     259     132      52      44      57   36827
       6    2293    1212    1086     836     286     207     113     175   33900
       7     167      40      74      43      16       2       0       6   32870
       8    8686    4295    4451    4038    1508     712     428     516   33576
       9    2536    1605    1500    1240     454     141     178     203   36789
      10    1725     924     833     534     230      97     102      74   34231
         P088001 P088002 P088003 P088004 P088005 P088006 P090001 P090002
           <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>   <dbl>
       1  547422   31195   20671   23121   26664   27495  141996   14484
       2    3513     335     267     258     289     238    1053     183
       3   60087    5301    3432    4045    4699    4575   16253    2861
       4   24414    2542    1797    1715    1856    1607    6336    1365
       5   13759     670     760     609     799     865    4004     479
       6   43858    3317    1961    3049    3234    3326   11966    1856
       7    2162     138     114     131     163     161     618      84
       8  169559   17227   11834   13993   13528   11923   42983    8676
       9   50908    3549    2237    2983    3122    3951   14118    1922
      10   30365    2525    1493    1658    1965    2407    8535    1287
      # i 23 more rows

---

    Code
      get_adi(geography = "county", state = "NM", year = 2020, dataset = "decennial",
        keep_indicators = TRUE, cache_tables = FALSE)
    Message
      
      2 call(s) to tidycensus beginning.
      Getting data from the 2020 decennial Census
      Using the Demographic and Housing Characteristics File
      Note: 2020 decennial Census data use differential privacy, a technique that
      introduces errors into data to preserve respondent confidentiality.
      i Small counts should be interpreted with caution.
      i See https://www.census.gov/library/fact-sheets/2021/protecting-the-confidentiality-of-the-2020-census-redistricting-data.html for additional guidance.
      This message is displayed once per session.
      Getting data from the 2016-2020 5-year ACS
    Output
      # A tibble: 33 x 137
         GEOID NAME                            ADI Financial_Strength
         <chr> <chr>                         <dbl>              <dbl>
       1 35001 Bernalillo County, New Mexico  84.3              120. 
       2 35003 Catron County, New Mexico     102.                87.3
       3 35005 Chaves County, New Mexico     106.                94.9
       4 35006 Cibola County, New Mexico     119.                86.4
       5 35007 Colfax County, New Mexico     107.                89.2
       6 35009 Curry County, New Mexico      103.                99.0
       7 35011 De Baca County, New Mexico     97.5              102. 
       8 35013 Doña Ana County, New Mexico   111.               101. 
       9 35015 Eddy County, New Mexico        85.3              113. 
      10 35017 Grant County, New Mexico      107.                94.3
         Economic_Hardship_and_Inequality Educational_Attainment medianFamilyIncome
                                    <dbl>                  <dbl>              <dbl>
       1                             94.3                  115.               69003
       2                             98.8                  123.               46264
       3                             95.8                   75.0              56190
       4                            123.                    87.2              55325
       5                            109.                   113.               49984
       6                            101.                    85.9              54162
       7                             96.3                  103.               65893
       8                            115.                    72.4              51928
       9                             80.2                   97.1              78029
      10                            112.                   107.               54879
         medianMortgage medianRent medianHouseValue pctFamiliesInPoverty
                  <dbl>      <dbl>            <dbl>                <dbl>
       1           1351        892           205500               0.118 
       2            978        720           162400               0.173 
       3           1115        808           115400               0.151 
       4            980        676            88800               0.209 
       5           1011        634           108900               0.169 
       6           1150        893           132400               0.164 
       7           1368        616           130000               0.0586
       8           1190        765           153600               0.207 
       9           1249        970           161100               0.132 
      10           1054        690           127100               0.179 
         pctOwnerOccupiedHousing ratioThoseMakingUnder10kToThoseMakingOver50k
                           <dbl>                                        <dbl>
       1                   0.617                                         2.70
       2                   0.852                                         3.21
       3                   0.678                                         2.81
       4                   0.744                                         3.16
       5                   0.704                                         3.16
       6                   0.580                                         2.77
       7                   0.749                                         3.25
       8                   0.647                                         3.11
       9                   0.691                                         2.38
      10                   0.723                                         3.43
         pctPeopleLivingBelow150PctFederalPovertyLevel
                                                 <dbl>
       1                                         0.261
       2                                         0.449
       3                                         0.345
       4                                         0.374
       5                                         0.362
       6                                         0.324
       7                                         0.280
       8                                         0.381
       9                                         0.247
      10                                         0.373
         pctHouseholdsWithChildrenThatAreSingleParent pctHouseholdsWithNoVehicle
                                                <dbl>                      <dbl>
       1                                        0.311                     0.0688
       2                                        0.245                     0.0440
       3                                        0.283                     0.0497
       4                                        0.379                     0.0657
       5                                        0.328                     0.0824
       6                                        0.300                     0.0362
       7                                        0.230                     0.110 
       8                                        0.327                     0.0620
       9                                        0.258                     0.0471
      10                                        0.314                     0.0565
         pctPeopleWithWhiteCollarJobs pctPeopleUnemployed
                                <dbl>               <dbl>
       1                        0.426              0.0559
       2                        0.203              0.0526
       3                        0.279              0.0521
       4                        0.283              0.116 
       5                        0.345              0.0466
       6                        0.287              0.0788
       7                        0.318              0.0976
       8                        0.352              0.0768
       9                        0.316              0.0430
      10                        0.344              0.0804
         pctPeopleWithAtLeastHSEducation pctPeopleWithLessThan9thGradeEducation
                                   <dbl>                                  <dbl>
       1                           0.900                                 0.0398
       2                           0.927                                 0.0451
       3                           0.794                                 0.109 
       4                           0.815                                 0.0438
       5                           0.875                                 0.0345
       6                           0.809                                 0.0766
       7                           0.820                                 0.0489
       8                           0.806                                 0.113 
       9                           0.836                                 0.0575
      10                           0.874                                 0.0492
         pctHouseholdsWithOverOnePersonPerRoom P16_001N B15002_001 B15002_003
                                         <dbl>    <dbl>      <dbl>      <dbl>
       1                               0.0256    279298     469939       2916
       2                               0.00259     1835       2858          0
       3                               0.0259     23521      41417        641
       4                               0.0773      9080      18217         31
       5                               0.0225      5519       9121         22
       6                               0.0346     18563      30515        278
       7                               0.00722      770        941          0
       8                               0.0417     82366     132723       1190
       9                               0.0316     22751      37467        321
      10                               0.0281     12269      19959         71
         B15002_004 B15002_005 B15002_006 B15002_011 B15002_012 B15002_013 B15002_014
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1381       2502       2158      54316      12777      39579      19024
       2         22          3        104        467         50        336        169
       3        577        778        463       5893       1446       3651       1132
       4         55         78        275       3316        416       1465        808
       5          8          9        134       1547        318        769        327
       6        156        413        219       4202       1244       2974       1248
       7          0          0          1        155         30        199         33
       8       1315       3634       1077      14359       3951      10039       4972
       9        265        467        189       6495       1464       2871       1142
      10         25        101        284       3103        504       2153        599
         B15002_015 B15002_016 B15002_017 B15002_018 B15002_020 B15002_021 B15002_022
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      41577      21690       6731       6939       2759        861       3512
       2        129         54         88          0          0          0          0
       3       2398        582        255        144        471        270        651
       4        780        485        141         11        102         19         44
       5        635        294         74         18         24          6         10
       6       1951        716        155         64        319         90        496
       7         31         24          0          0          0          1         39
       8      10401       5200       1194       1298       1246       1591       3386
       9       2037        817         62        172        243        104        327
      10       1437        564         87        117         36         44         66
         B15002_023 B15002_028 B15002_029 B15002_030 B15002_031 B15002_032 B15002_033
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       2619      53414      15941      40302      21760      50209      28702
       2          0        733         81        305         32        157         36
       3        678       5120       2144       3480       2684       2524       1178
       4        193       2210        534       1831       1105       1225        385
       5        102       1224        438        856        549        554        285
       6        365       3672       1006       2583       1601       2182        914
       7          5        105         18         91         16         32         38
       8       1506      14180       4394      10064       5809      12514       6800
       9        238       5676       1305       3340       2603       1984       1303
      10        354       2552        459       1875       1087       1663       1017
         B15002_034 B15002_035 B17010_001 B17010_002 B19001_002 B19001_011 B19001_012
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       5524       4430     159218      18794      21750      21474      26988
       2          0         12        874        151        120        151        128
       3        105        135      15888       2405       1860       2186       2160
       4         88         39       5807       1211        920        758        864
       5         23         71       3339        563        531        555        500
       6        152         36      12131       1985       1449       1713       2066
       7          0          0        273         16         56         32         52
       8       1093        654      52075      10769       8071       7188       7018
       9         19         39      15122       1994       1419       1511       2318
      10        107        123       6146       1100       1407        679        702
         B19001_013 B19001_014 B19001_015 B19001_016 B19001_017 B19113_001 B23001_006
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      33601      23279      13509      13924      13587      69003       6925
       2         72         85         25         14          7      46264          0
       3       2775       1447       1216        830        581      56190        968
       4        873        730        275        283        101      55325        251
       5        392        452        111        153         99      49984        112
       6       2739       1097        668        485        319      54162        728
       7         62         49          8         14          1      65893         51
       8       7549       6035       3559       2655       1919      51928       2626
       9       2348       2512       1349       1978       1064      78029        928
      10       1225       1101        230        296        315      54879        198
         B23001_008 B23001_013 B23001_015 B23001_020 B23001_022 B23001_027 B23001_029
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        990       6387        940      10670        888      22348       1578
       2          0         15          0          2          0          4          0
       3        198        713         88        998        115       1777         63
       4         95        122         35        382         53        648         80
       5          0         89          0        194          0        352         75
       6        125        586        225       1055         98       1632         38
       7          0         42          0          0          0        111          0
       8        473       3277        378       4679        469       5999        417
       9         71        532          0        964        118       1882        113
      10          0        206         18        345         23        649         12
         B23001_034 B23001_036 B23001_041 B23001_043 B23001_048 B23001_050 B23001_055
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      21851       1331      37290       1338      32753       1443      15139
       2          0          0        145          0         29          0        146
       3       1657        106       2840         47       2702         79       1184
       4        703         78       1106         90        818         69        520
       5        212          0        598          1        426         17        230
       6       1247         72       2321        101       1867         70       1000
       7         55          0         61          0         59          4         29
       8       5812        378       9744        732       8487        344       3699
       9       1986        227       3399        182       2748         22       1211
      10        335          5       1249        217        771         35        487
         B23001_057 B23001_062 B23001_064 B23001_069 B23001_071 B23001_074 B23001_076
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        535       5162        286       6012        231       6034        267
       2         40          3          0         11          0         49          0
       3         11        433         24        622         77        503          0
       4         54        136         11        125          3         84          0
       5         19        135         14        155         23        158         23
       6         90        340          0        434         34        275          0
       7          0         16          0         11          0         12          0
       8        222       1508         82       1522         19       1845        107
       9         47        648          0        583         12        460          5
      10         21        206          0        172         28        218         14
         B23001_079 B23001_081 B23001_084 B23001_086 B23001_092 B23001_094 B23001_099
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       2450        179       1587         55       6968       1254       6623
       2          0          0         41          0          0          0         14
       3        202         10        183          0        529         24        482
       4         24          0          0          0        229        110        214
       5        101          0         10          0        147         14         56
       6        155          0        201          0        449         89        441
       7          3          0          0          0          0          0          0
       8        870         15        377         21       2057        350       2482
       9        212          0         76          0        539        102        605
      10         94          0         26          0        281         20        197
         B23001_101 B23001_106 B23001_108 B23001_113 B23001_115 B23001_120 B23001_122
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        432       9972        681      19994       1217      19615        958
       2          0         21          7         14          0          3          0
       3         17        974         96       1507        100       1438         39
       4         46        317         63        741         44        470        115
       5          0        131          0        207          0        231          7
       6         26        704         44       1397        153       1316        278
       7          0         50          0         20          0         12          8
       8        462       5442        381       5580        918       4191        251
       9          0        636          0       1137         81       1264         39
      10         28        263          4        528         20        506         11
         B23001_127 B23001_129 B23001_134 B23001_136 B23001_141 B23001_143 B23001_148
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1      33818       1354      30899       1241      16430        962       5524
       2        157          0         84          0         55          0         56
       3       2866        131       2840        131       1324         87        599
       4       1052         79        807         60        370          7        260
       5        399          8        438         20        291         18         67
       6       1812        139       1525         49       1026         40        300
       7        113         53         16          0         21          0          9
       8       8451        499       8331        341       3764        198       1444
       9       2698        123       2293         11       1047          7        381
      10        964        313       1019         46        632          9        190
         B23001_150 B23001_155 B23001_157 B23001_160 B23001_162 B23001_165 B23001_167
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        138       5665        225       5861        300       2419         92
       2          0          0          0         38          0          0          0
       3         14        403          0        387         22        410          0
       4         71        205          0        260          0        141          0
       5          0        173          0        144          0         46          0
       6          0        192         20        275          0        103          3
       7          0          3          0          1          0          8          0
       8         95       1777         23       1219         89        458        109
       9         20        488          0        374          0        241          0
      10          6        453          6        243          0        121          0
         B23001_170 B23001_172 B25014_001 B25014_005 B25014_006 B25014_007 B25014_011
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1        890         53     272528       1583        426        349       2884
       2          6          0       1546          4          0          0          0
       3         93         14      23641        283         37         76        183
       4         38          0       8408        300         87         48        134
       5         25          0       5946         22         31          0         81
       6        124          0      18620        178         70         40        220
       7          4          4        554          0          4          0          0
       8        365          0      79421        877        328        145       1476
       9        140          0      21548        164         71         19        312
      10         45          0      11496         79        149          0         66
         B25014_012 B25014_013 B25044_001 B25044_003 B25044_010 B25064_001 B25077_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1562        174     272528       4414      14345        892     205500
       2          0          0       1546         12         56        720     162400
       3         19         14      23641        377        797        808     115400
       4         61         20       8408        284        268        676      88800
       5          0          0       5946        140        350        634     108900
       6        102         34      18620        161        513        893     132400
       7          0          0        554          1         60        616     130000
       8        175        312      79421       1409       3516        765     153600
       9        115          0      21548        522        492        970     161100
      10         17         12      11496        325        325        690     127100
         B25088_002 C17002_001 C17002_002 C17002_003 C17002_004 C17002_005 C24010_001
              <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>      <dbl>
       1       1351     670607      50232      56413      35374      32772     320318
       2        978       3505        166        699        211        497        846
       3       1115      62522       4751       7377       5706       3756      27141
       4        980      25362       2468       4011       1516       1501       8860
       5       1011      11520        730       1743        877        819       4888
       6       1150      48422       4464       4690       3089       3446      19811
       7       1368       1974         46        229        223         54        638
       8       1190     211956      20965      31670      14281      13890      88633
       9       1249      57049       3988       5130       1879       3106      26292
      10       1054      26530       2794       3947        997       2145       9562
         C24010_003 C24010_039 H10_002N H3_002N P20_003N P20_006N P20_011N P20_017N
              <dbl>      <dbl>    <dbl>   <dbl>    <dbl>    <dbl>    <dbl>    <dbl>
       1      63636      72717   172281  279298    37977     8033     5535    15225
       2        113         59     1563    1835       95       16       16       20
       3       3114       4463    15957   23521     4169      945      484     1532
       4       1187       1318     6754    9080      918      405      214      593
       5        761        923     3886    5519      525      160       98      236
       6       2355       3326    10761   18563     3322      581      416     1256
       7         73        130      577     770       93       21       10       24
       8      14424      16766    53271   82366    12393     2655     1501     5800
       9       3862       4435    15710   22751     4255      884      542     1242
      10       1117       2176     8867   12269     1229      336      175      543
      # i 23 more rows

