% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_forest2.R
\name{sm_forest}
\alias{sm_forest}
\title{Forest plot}
\usage{
sm_forest(
  ...,
  point.params = list(size = 2.5, alpha = 0.3),
  avgPoint.params = list(size = 5.5, shape = 18),
  err.params = list(color = "black"),
  ref.params = list(size = 0.4, color = "gray80", linetype = "dashed"),
  xintercept = 0,
  sep_level = 2,
  point_jitter_width = 0,
  errorbar_type = "ci",
  points = TRUE,
  refLine = TRUE,
  borders = TRUE,
  legends = FALSE,
  seed = NULL,
  forget = FALSE
)
}
\arguments{
\item{...}{A generic aesthetic parameter across points, lines and error bars. This
is optional.}

\item{point.params}{List of parameters for individual points, such as color, alpha, fill etc}

\item{avgPoint.params}{List of parameters for the average point, such as color, alpha, fill etc}

\item{err.params}{List of parameters for the error bar from the average point, such as color, alpha etc}

\item{ref.params}{List of parameters for the vertical reference line, such as color, alpha etc}

\item{xintercept}{Location of the vertical reference line along the x coordinate.}

\item{sep_level}{A numerical value that controls the level of the separation between
the individual points and the average point.
If it's 0, all of these are clustered together. If it's higher (and more positive),
the text annotations will increasingly go below the mean point. Default is set to 2. The values
can be negative so that the points can be above the mean point. There is no limit of
the range for this argument.}

\item{point_jitter_width}{A numerical value that determines the degree of the jitter for each point. If its 0,
all the points will have no jitter (aligned along the y-axis).}

\item{errorbar_type}{This argument determines the error bar type.
If it is set to 'se' , standard error bar will be shown.
If it is set to 'sd', the error bar will display standard deviation.
If it is set to 'ci' (default), the error bar will display 95\% confidence interval.}

\item{points}{If points is set TRUE, individual points are shown. If FALSE,
they are not shown.}

\item{refLine}{If it is set TRUE, the reference line at a specified location along the x-axis is shown.
If it is set FALSE, it is not shown.}

\item{borders}{If the border needs to be displayed, the input should be TRUE.
If the border is not needed, the input should be FALSE.}

\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{seed}{Random seed}

\item{forget}{Forget the defaults when list() is called for a specific parameter (ex. point.params).
Set to TRUE when when users want to map aesthetics to different groups more flexibly..
Set to FALSE by default.}
}
\value{
A forest plot generated using ggplot2
}
\description{
Forest plot
}
\examples{
library(smplot2)
library(ggplot2)

day1 <- rnorm(20, 0, 1)
day2 <- rnorm(20, 5, 1)
day3 <- rnorm(20, 6, 1.5)
day4 <- rnorm(20, 7, 2)
Subject <- rep(paste0("S", seq(1:20)), 4)
Data <- data.frame(Value = matrix(c(day1, day2, day3, day4), ncol = 1))
Day <- rep(c("Day 1", "Day 2", "Day 3", "Day 4"), each = length(day1))
df2 <- cbind(Subject, Data, Day)

ggplot(data = df2, aes(x = Value, y = Day, color = Day, fill = Day)) +
  sm_forest(
    sep_level = 2, point_jitter_width = .12,
    errorbar_type = "ci",
    point.params = list(alpha = 0.2)
  ) +
  scale_color_manual(values = sm_palette(4))
}
